/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.browser;

import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.browser.CoreBrowserEditor;
import com.aptana.ide.intro.browser.CoreBrowserEditorInput;
import com.aptana.ide.intro.browser.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class BrowserEditorHelper {
    public static CoreBrowserEditor openBrowserEditor(URL url, String name, ImageDescriptor image, String toolTip, String script) throws PartInitException {
        return BrowserEditorHelper.openBrowserEditor(url, name, image, toolTip, script, false);
    }

    public static CoreBrowserEditor openBrowserEditor(URL url, String name, ImageDescriptor image, String toolTip, String script, boolean oneAllowed) throws PartInitException {
        IWorkbenchPage page;
        IEditorPart part;
        String id = Long.toString(System.currentTimeMillis());
        if (oneAllowed) {
            String value = url.toExternalForm();
            if (!value.endsWith("?")) {
                value = String.valueOf(value) + "?";
            }
            value = String.valueOf(value) + "hc=" + id;
            try {
                url = new URL(value);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        CoreBrowserEditorInput input = new CoreBrowserEditorInput(url, 0);
        if (oneAllowed) {
            input.setInputID(id);
        }
        input.setName(name);
        input.setOnlyOneAllowed(true);
        input.setToolTipText(toolTip);
        input.setImage(image);
        input.setScript(script);
        IWorkbenchWindow window = IntroPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (part = IDE.openEditor((IWorkbenchPage)(page = window.getActivePage()), (IEditorInput)input, (String)"com.aptana.ide.intro.browserEditor")) instanceof CoreBrowserEditor) {
            return (CoreBrowserEditor)part;
        }
        return null;
    }

    public static CoreBrowserEditor openBrowserEditor(URL url, boolean oneAllowed) throws PartInitException {
        return BrowserEditorHelper.openBrowserEditor(url, Messages.BrowserEditorHelper_BrowserName, null, null, null, oneAllowed);
    }

    public static CoreBrowserEditor openBrowserEditor(URL url) throws PartInitException {
        return BrowserEditorHelper.openBrowserEditor(url, Messages.BrowserEditorHelper_BrowserName, null, null, null, false);
    }
}

