/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.wizards.BaseWizard;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.actions.ClientUtils;
import com.aptana.ide.intro.actions.Messages;
import com.aptana.ide.server.jetty.comet.CometClient;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class OpenWizardClient
extends CometClient {
    public static final String WIZARD_CHANNEL = "/portal/wizard";
    public static final String DATA = "data";

    protected Object getResponse(String toChannel, Object request) {
        Map requestData;
        if (WIZARD_CHANNEL.equals(toChannel) && request instanceof Map && (requestData = (Map)request).containsKey("id") && requestData.containsKey("request")) {
            final String id = requestData.get("id").toString();
            final String type = requestData.get("request").toString();
            final Object data = requestData.get(DATA);
            UIJob job = new UIJob(Messages.OpenWizardClient_Job_OpenWizard){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        if (id != null) {
                            IWizardDescriptor descriptor = null;
                            if ("import".equals(type)) {
                                descriptor = PlatformUI.getWorkbench().getImportWizardRegistry().findWizard(id);
                            } else if ("export".equals(type)) {
                                descriptor = PlatformUI.getWorkbench().getExportWizardRegistry().findWizard(id);
                            } else if ("new".equals(type)) {
                                descriptor = PlatformUI.getWorkbench().getNewWizardRegistry().findWizard(id);
                            }
                            if (descriptor != null) {
                                IWorkbenchWizard wizard = descriptor.createWizard();
                                wizard.init(IntroPlugin.getDefault().getWorkbench(), ClientUtils.getNavigatorSelection());
                                if (data != null && wizard instanceof BaseWizard) {
                                    ((BaseWizard)wizard).setInitializationData(data);
                                }
                                if (wizard instanceof IWizard) {
                                    WizardDialog dialog = new WizardDialog(CoreUIUtils.getActiveShell(), (IWizard)wizard);
                                    dialog.create();
                                    if (wizard.getPageCount() > 0) {
                                        dialog.open();
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)Messages.OpenWizardClient_INF_ErrorLaunchWizard, (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return null;
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{WIZARD_CHANNEL};
    }

    protected String getID(String msgId) {
        return WIZARD_CHANNEL;
    }
}

