/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.intro.FeatureChange;
import com.aptana.ide.intro.IntroPlugin;
import com.aptana.ide.intro.Messages;
import com.aptana.ide.update.FeatureUtil;
import com.aptana.ide.update.manager.IPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureChangeManager {
    private static FeatureChangeManager manager = null;
    public static final String FEATURE_STORE_PATH = ".features";
    private List<FeatureChange> changeList;
    private boolean changed;

    private FeatureChangeManager() {
        List plugins = FeatureUtil.getInstalledFeatures();
        try {
            List<FeatureChange> changes = this.compareToStore(plugins);
            boolean bl = this.changed = !changes.isEmpty();
            if (this.changed) {
                this.changeList = changes;
                this.updateStore(plugins);
            } else {
                this.changeList = null;
            }
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
            this.updateStore(plugins);
            this.changed = false;
            this.changeList = null;
        }
    }

    public static synchronized FeatureChangeManager getManager() {
        if (manager == null) {
            manager = new FeatureChangeManager();
        }
        return manager;
    }

    public boolean areFeaturesChanged() {
        return this.changed;
    }

    public List<FeatureChange> getFeatureChangeList() {
        return this.changeList;
    }

    private void updateStore(List<IPlugin> plugins) {
        HashMap<String, String> newIdsToVersion = new HashMap<String, String>();
        for (IPlugin ref : plugins) {
            newIdsToVersion.put(ref.getId(), ref.getVersion());
            IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)MessageFormat.format(Messages.FeatureChangeManager_INF_Feature, ref.getId(), ref.getVersion()));
        }
        this.saveFeatureInformation(newIdsToVersion);
    }

    private List<FeatureChange> compareToStore(List<IPlugin> plugins) throws FileNotFoundException, IOException, ClassNotFoundException {
        Map<String, String> idToVersions = this.getStoredVersions();
        ArrayList<FeatureChange> changes = new ArrayList<FeatureChange>();
        for (IPlugin ref : plugins) {
            String currentVersion = ref.getVersion();
            FeatureChange change = null;
            if (idToVersions.containsKey(ref.getId())) {
                String previous = idToVersions.get(ref.getId());
                if (!previous.equals(currentVersion)) {
                    change = new FeatureChange(ref.getId(), ref.getName(), previous, currentVersion, this.getProvider(ref));
                }
            } else {
                change = new FeatureChange(ref.getId(), ref.getName(), null, currentVersion, this.getProvider(ref));
            }
            if (change == null) continue;
            changes.add(change);
        }
        return changes;
    }

    private Map<String, String> getStoredVersions() throws IOException, ClassNotFoundException {
        File bundleFile = IntroPlugin.getDefault().getStateLocation().append(FEATURE_STORE_PATH).toFile();
        if (!bundleFile.exists()) {
            throw new IOException("Feature store does not exist");
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(bundleFile));
            Object obj = ois.readObject();
            if (obj instanceof Map) {
                Map map = (Map)obj;
                return map;
            }
            throw new IOException("File empty or corrupted");
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    private String getProvider(IPlugin ref) {
        if (ref == null || ref.getId() == null) {
            return "";
        }
        if (ref.getId().contains("aptana") || ref.getId().contains("radrails") || ref.getId().contains("rubypeople") || ref.getId().contains("pydev")) {
            return "Aptana, Inc.";
        }
        return "";
    }

    private void saveFeatureInformation(HashMap<String, String> idToVersions) {
        block16: {
            ObjectOutputStream oos = null;
            try {
                try {
                    if (IntroPlugin.getDefault() != null && IntroPlugin.getDefault().getStateLocation() != null) {
                        File bundleFile = IntroPlugin.getDefault().getStateLocation().append(FEATURE_STORE_PATH).toFile();
                        if (!bundleFile.exists()) {
                            bundleFile.createNewFile();
                        }
                        IdeLog.logInfo((Plugin)IntroPlugin.getDefault(), (String)Messages.FeatureChangeManager_INF_PersistList);
                        oos = new ObjectOutputStream(new FileOutputStream(bundleFile));
                        oos.writeObject(idToVersions);
                        oos.flush();
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)IntroPlugin.getDefault(), (String)e.getMessage());
                    try {
                        if (oos != null) {
                            oos.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

