/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.parsing;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.html.parsing.nodes.HTMLSpecialNode;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.xpath.ParseNodeXPath;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.parsing.Messages;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.jaxen.JaxenException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ParseNode
extends ScriptableObject {
    private static final long serialVersionUID = 5067105792229240288L;
    private IParseNode _node;

    public ParseNode(Scriptable scope, IParseNode node) {
        if (node == null) {
            throw new IllegalArgumentException(Messages.ParseNode_Node_Undefined);
        }
        Scriptable object = (Scriptable)scope.get("Object", scope);
        this.setPrototype(object.getPrototype());
        this.setParentScope(scope);
        this._node = node;
        String[] names = new String[]{"evaluate", "getAttribute", "hasAttribute", "getChild"};
        this.defineFunctionProperties(names, ParseNode.class, 5);
        this.defineProperty("endOffset", ParseNode.class, 5);
        this.defineProperty("childCount", ParseNode.class, 5);
        this.defineProperty("children", ParseNode.class, 5);
        this.defineProperty("iconBaseName", ParseNode.class, 5);
        this.defineProperty("language", ParseNode.class, 5);
        this.defineProperty("name", ParseNode.class, 5);
        this.defineProperty("parent", ParseNode.class, 5);
        this.defineProperty("source", ParseNode.class, 5);
        this.defineProperty("startOffset", ParseNode.class, 5);
        this.defineProperty("typeIndex", ParseNode.class, 5);
        this.defineProperty("text", ParseNode.class, 5);
        this.defineProperty("xml", ParseNode.class, 5);
        this.defineProperty("node", ParseNode.class, 5);
    }

    public Object evaluate(String xpathExpr) {
        Scriptable scope = this.getParentScope();
        List xpathResult = null;
        try {
            ParseNodeXPath xpath = new ParseNodeXPath(xpathExpr);
            xpathResult = (List)xpath.evaluate((Object)this._node);
        }
        catch (JaxenException e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ParseNode_Error, (Throwable)e);
        }
        if (xpathResult != null) {
            Object[] elements = new Object[xpathResult.size()];
            int i = 0;
            while (i < xpathResult.size()) {
                elements[i] = new ParseNode(scope, (IParseNode)xpathResult.get(i));
                ++i;
            }
            return Context.getCurrentContext().newArray(scope, elements);
        }
        return Context.getCurrentContext().newArray(scope, new Object[0]);
    }

    public String getAttribute(String name) {
        return this._node.getAttribute(name);
    }

    public Scriptable getChild(int index) {
        Scriptable scope = this.getParentScope();
        return new ParseNode(scope, this._node.getChild(index));
    }

    public int getChildCount() {
        return this._node.getChildCount();
    }

    public Scriptable getChildren() {
        Scriptable scope = this.getParentScope();
        IParseNode[] nodes = this._node.getChildren();
        if (nodes == null) {
            return Context.getCurrentContext().newArray(scope, new Object[0]);
        }
        Object[] elements = new Object[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            elements[i] = new ParseNode(scope, nodes[i]);
            ++i;
        }
        return Context.getCurrentContext().newArray(scope, elements);
    }

    public String getClassName() {
        return "ParseNode";
    }

    public int getEndOffset() {
        return this._node.getEndingOffset();
    }

    public String getIconBaseName() {
        String result = "";
        if (this._node instanceof HTMLSpecialNode) {
            HTMLSpecialNode node = (HTMLSpecialNode)this._node;
            result = node.getIconBaseName();
        }
        return result;
    }

    public String getLanguage() {
        return this._node.getLanguage();
    }

    public String getName() {
        return this._node.getName();
    }

    public IParseNode getNode() {
        return this._node;
    }

    public Object getParent() {
        Scriptable scope = this.getParentScope();
        IParseNode parent = this._node.getParent();
        if (parent == null) {
            return Context.getUndefinedValue();
        }
        return new ParseNode(scope, parent);
    }

    public String getSource() {
        return this._node.getSource();
    }

    public int getStartOffset() {
        return this._node.getStartingOffset();
    }

    public String getText() {
        return this._node.getText();
    }

    public int getTypeIndex() {
        return this._node.getTypeIndex();
    }

    public String getXml() {
        return this._node.getXML();
    }

    public boolean hasAttribute(String name) {
        return this._node.hasAttribute(name);
    }
}

