/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting.io;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.scripting.io.Messages;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Plugin;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class File
extends ScriptableObject {
    private static final long serialVersionUID = 622033917776635991L;
    private java.io.File file;

    public static void finishInit(Scriptable scope, FunctionObject constructor, Scriptable prototype) {
        constructor.defineProperty("separator", (Object)java.io.File.separator, 5);
    }

    public String getClassName() {
        return "File";
    }

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        File result = new File();
        Object arg = args[0];
        if (arg instanceof java.io.File) {
            result.file = (java.io.File)arg;
        } else {
            String name = Context.toString((Object)arg);
            result.file = new java.io.File(name);
        }
        return result;
    }

    public boolean jsFunction_createNewFile() {
        boolean result = false;
        try {
            result = this.file.createNewFile();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.File_Error, (Throwable)e);
        }
        return result;
    }

    public boolean jsFunction_createDirectory(boolean recursive) {
        boolean result = false;
        result = recursive ? this.file.mkdirs() : this.file.mkdir();
        return result;
    }

    public void jsFunction_deleteOnExit() {
        if (this.file != null) {
            this.file.deleteOnExit();
        }
    }

    public Scriptable jsFunction_readLines() {
        ArrayList<String> lines;
        Context cx;
        block18: {
            cx = Context.getCurrentContext();
            lines = new ArrayList<String>();
            BufferedReader br = null;
            try {
                FileReader fr = new FileReader(this.file);
                br = new BufferedReader(fr);
                String line = br.readLine();
                while (line != null) {
                    lines.add(line);
                    line = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.File_Error, (Throwable)e);
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.File_Error, (Throwable)e2);
                    }
                }
                break block18;
            }
            catch (IOException e) {
                try {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.File_Error, (Throwable)e);
                    break block18;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e3) {
                            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.File_Error, (Throwable)e3);
                        }
                    }
                }
            }
            if (br == null) break block18;
            try {
                br.close();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.File_Error, (Throwable)e);
            }
        }
        return cx.newArray(this.getParentScope(), lines.toArray());
    }

    public boolean jsFunction_write(String text) {
        try {
            FileWriter fw = new FileWriter(this.file);
            fw.write(text);
            fw.close();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.File_Error, (Throwable)e);
            return false;
        }
        return true;
    }

    public String jsGet_absolutePath() {
        return this.file.getAbsolutePath();
    }

    public String jsGet_baseName() {
        String name = this.file.getName();
        int index = name.lastIndexOf(46);
        String result = name;
        if (index != -1) {
            result = name.substring(0, index);
        }
        return result;
    }

    public boolean jsGet_canRead() {
        return this.file.canRead();
    }

    public boolean jsGet_canWrite() {
        return this.file.canWrite();
    }

    public boolean jsGet_exists() {
        return this.file.exists();
    }

    public String jsGet_extension() {
        String name = this.file.getName();
        int index = name.lastIndexOf(46);
        String result = "";
        if (index != -1) {
            result = name.substring(index);
        }
        return result;
    }

    public boolean jsGet_isFile() {
        return this.file.isFile();
    }

    public boolean jsGet_isDirectory() {
        return this.file.isDirectory();
    }

    public Scriptable jsGet_list() {
        Context cx = Context.getCurrentContext();
        Scriptable scope = this.getParentScope();
        String baseName = String.valueOf(this.file.getAbsolutePath()) + java.io.File.separator;
        String[] names = this.file.list();
        int length = names.length;
        Object[] result = new Object[length];
        int i = 0;
        while (i < length) {
            String name = String.valueOf(baseName) + names[i];
            result[i] = cx.newObject(scope, "File", new Object[]{name});
            ++i;
        }
        return cx.newArray(scope, result);
    }

    public String jsGet_name() {
        return this.file.getName();
    }

    public Scriptable jsGet_parentFile() {
        Context cx = Context.getCurrentContext();
        Scriptable scope = this.getParentScope();
        String parent = this.file.getParent();
        return cx.newObject(scope, "File", new Object[]{parent});
    }
}

