/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.scripting.Messages;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.osgi.framework.Bundle;

public class ScriptClassLoader
extends ClassLoader {
    private ArrayList _bundles = new ArrayList();

    public ScriptClassLoader() {
        super(ScriptClassLoader.class.getClassLoader());
    }

    public void addBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException(Messages.ScriptClassLoader_Bundle_Not_Defined);
        }
        if (!this._bundles.contains(bundle)) {
            this._bundles.add(bundle);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class result = this.loadClassFromBundles(name);
        if (result == null) {
            String message = StringUtils.format((String)Messages.ScriptClassLoader_Unable_To_Find_Class, (String)name);
            throw new ClassNotFoundException(message);
        }
        return result;
    }

    protected URL findResource(String name) {
        URL result = super.findResource(name);
        if (result == null) {
            for (Bundle bundle : this._bundles) {
                result = bundle.getResource(name);
                if (result != null) break;
            }
        }
        return result;
    }

    protected Enumeration findResources(String name) throws IOException {
        Enumeration result = super.findResources(name);
        if (result == null) {
            for (Bundle bundle : this._bundles) {
                result = bundle.getResources(name);
                if (result != null) break;
            }
        }
        if (result == null) {
            String message = StringUtils.format((String)Messages.ScriptClassLoader_Unable_To_Find_Resource, (String)name);
            throw new IOException(message);
        }
        return result;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class result = super.loadClass(name);
        if (result == null) {
            result = this.loadClassFromBundles(name);
        }
        if (result == null) {
            String message = StringUtils.format((String)Messages.ScriptClassLoader_Unable_To_Load_Class, (String)name);
            throw new ClassNotFoundException(message);
        }
        return result;
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class result = super.loadClass(name, resolve);
        if (result == null) {
            result = this.loadClassFromBundles(name);
        }
        if (result == null) {
            String message = StringUtils.format((String)Messages.ScriptClassLoader_Unable_To_Load_Class, (String)name);
            throw new ClassNotFoundException(message);
        }
        return result;
    }

    private Class loadClassFromBundles(String name) {
        Class result = null;
        for (Bundle bundle : this._bundles) {
            try {
                result = bundle.loadClass(name);
                if (result == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return result;
    }
}

