/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.update;

import com.aptana.ide.update.Activator;
import com.aptana.ide.update.manager.Plugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class PluginsImageRegistry {
    private static final Image DEFAULT_IMAGE = Activator.getImageDescriptor("images/plugin.png").createImage();
    private ImageRegistry fImages;

    public PluginsImageRegistry(Display display) {
        this.fImages = new ImageRegistry(display);
    }

    public Image getImage(Plugin plugin) {
        Image image = null;
        String path = plugin.getImagePath();
        if (path != null && (image = this.fImages.get(path)) == null) {
            ImageDescriptor descriptor = Activator.getImageDescriptor(path);
            if (descriptor == null) {
                try {
                    image = ImageDescriptor.createFromURL((URL)this.getURL(path)).createImage();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                image = descriptor.createImage();
            }
            if (image != null) {
                this.fImages.put(path, image);
            }
        }
        return image == null ? DEFAULT_IMAGE : image;
    }

    public static Image getDefaultImage() {
        return DEFAULT_IMAGE;
    }

    private URL getURL(String location) throws MalformedURLException {
        try {
            return new File(location).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return new URL(location);
        }
    }
}

