
%{

/* 
 * Tokenizer for COBF
 * BB 
 * 1994-10-23 file created
 * 2003-01-01 adaptions for most recent GNU flex version (2.5)
 *
 * This inputfile ist the source for lex_yy.cc/cpp which should be generated by GNU-Flex
*/


#define YYX_LINENO cobf_lineno /* yylineno not supported by POSIX-LEX! */
#define YYX_INCLINE() ++YYX_LINENO
int YYX_LINENO;

#include <iostream.h>
#include "b_tcont.h"
#include "scan.h"

%}

D			[0-9]
L			[a-zA-Z_]
H			[a-fA-F0-9]
E			[Ee][+-]?{D}+
FS			(f|F|l|L)
IS			(u|U|l|L)*

%%

"/*"			{ skip_comment1(); }
"//"			{ skip_comment2(); }

"\n"[ \t\r]*"#"[ \t\r]*		{ YYX_INCLINE(); return HASH; }
"\n"[ \t\r]*"%%%%%"[ \t\r]*	{ YYX_INCLINE(); return HASH; }

"\""			{ skip_string(); return STRING; }

{L}({L}|{D})*		{ return IDENTIFIER; }

0[xX]{H}+{IS}?		{ return NUMBER; }
0{D}+{IS}?		{ return NUMBER; }
{D}+{IS}?		{ return NUMBER; }

{D}+{E}{FS}?		{ return NUMBER; }
{D}*"."{D}+({E})?{FS}?	{ return NUMBER; }
{D}+"."{D}*({E})?{FS}?	{ return NUMBER; }

'(\\.|[^\\'])+'		{ return CHAR; }

"+="			{ return OP; }
"-="			{ return OP; }
"*="			{ return OP; }
"/="			{ return OP; }
"%="			{ return OP; }
">>="			{ return OP; }
"<<="			{ return OP; }
"&="			{ return OP; }
"|="			{ return OP; }
"^="			{ return OP; }

"<="			{ return OP; }
">="			{ return OP; }
"=="			{ return OP; }
"!="			{ return OP; }

"->"			{ return OP; }
"->*"			{ return OP; }
".*"			{ return OP; }

"..."			{ return OP; }
"::"			{ return OP; }

">>"			{ return OP; }
"<<"			{ return OP; }
"++"			{ return OP; }
"--"			{ return OP; }
"&&"			{ return OP; }
"||"			{ return OP; }

[\.\<\>\=\+\-\*\/\%\&\^\|\!;\,\{\}\:\(\)\[\]\~\?] { return OP; }

"#"			{ return QUOTE_HASH; }
"##"			{ return CONCAT_HASH; }

"%%("[^\)]*")"		{ skip_tpp_id(); return IDENTIFIER; }
"%%%"			{ return QUOTE_HASH; }
"%%%%"			{ return CONCAT_HASH; }

"\\"[ \t\r]*"\n"	{ YYX_INCLINE(); }

"\n"			{ YYX_INCLINE(); return NEWLINE; }
[ \t\v\r\f]		{ return WHITESPACE; }

.			yyerror("illegal char '%c' (ascii %d)", *yytext, (unsigned char) *yytext);

%%

#include "scanproc.h"



