/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AReference;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class Namespace
extends AReference {
    public final Symbol name;
    final AtomicReference<IPersistentMap> mappings = new AtomicReference();
    final AtomicReference<IPersistentMap> aliases = new AtomicReference();
    static final ConcurrentHashMap<Symbol, Namespace> namespaces = new ConcurrentHashMap();

    public String toString() {
        return this.name.toString();
    }

    Namespace(Symbol name) {
        super(name.meta());
        this.name = name;
        this.mappings.set(RT.DEFAULT_IMPORTS);
        this.aliases.set(RT.map(new Object[0]));
    }

    public static ISeq all() {
        return RT.seq(namespaces.values());
    }

    public Symbol getName() {
        return this.name;
    }

    public IPersistentMap getMappings() {
        return this.mappings.get();
    }

    public Var intern(Symbol sym) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        Var v = null;
        while ((o = map.valAt(sym)) == null) {
            if (v == null) {
                v = new Var(this, sym);
            }
            IPersistentMap newMap = map.assoc(sym, v);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
        if (o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        throw new IllegalStateException(sym + " already refers to: " + o + " in namespace: " + this.name);
    }

    Object reference(Symbol sym, Object val) {
        Object o;
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't intern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        while ((o = map.valAt(sym)) == null) {
            IPersistentMap newMap = map.assoc(sym, val);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
        if (o == val) {
            return o;
        }
        throw new IllegalStateException(sym + " already refers to: " + o + " in namespace: " + this.name);
    }

    public void unmap(Symbol sym) throws Exception {
        if (sym.ns != null) {
            throw new IllegalArgumentException("Can't unintern namespace-qualified symbol");
        }
        IPersistentMap map = this.getMappings();
        while (map.containsKey(sym)) {
            IPersistentMap newMap = map.without(sym);
            this.mappings.compareAndSet(map, newMap);
            map = this.getMappings();
        }
    }

    public Class importClass(Symbol sym, Class c) {
        return (Class)this.reference(sym, c);
    }

    public Var refer(Symbol sym, Var var) {
        return (Var)this.reference(sym, var);
    }

    public static Namespace findOrCreate(Symbol name) {
        Namespace ns = namespaces.get(name);
        if (ns != null) {
            return ns;
        }
        Namespace newns = new Namespace(name);
        ns = namespaces.putIfAbsent(name, newns);
        return ns == null ? newns : ns;
    }

    public static Namespace remove(Symbol name) {
        if (name.equals(RT.CLOJURE_NS.name)) {
            throw new IllegalArgumentException("Cannot remove clojure namespace");
        }
        return namespaces.remove(name);
    }

    public static Namespace find(Symbol name) {
        return namespaces.get(name);
    }

    public Object getMapping(Symbol name) {
        return this.mappings.get().valAt(name);
    }

    public Var findInternedVar(Symbol symbol) {
        Object o = this.mappings.get().valAt(symbol);
        if (o != null && o instanceof Var && ((Var)o).ns == this) {
            return (Var)o;
        }
        return null;
    }

    public IPersistentMap getAliases() {
        return this.aliases.get();
    }

    public Namespace lookupAlias(Symbol alias) {
        IPersistentMap map = this.getAliases();
        return (Namespace)map.valAt(alias);
    }

    public void addAlias(Symbol alias, Namespace ns) {
        if (alias == null || ns == null) {
            throw new NullPointerException("Expecting Symbol + Namespace");
        }
        IPersistentMap map = this.getAliases();
        while (!map.containsKey(alias)) {
            IPersistentMap newMap = map.assoc(alias, ns);
            this.aliases.compareAndSet(map, newMap);
            map = this.getAliases();
        }
        if (!map.valAt(alias).equals(ns)) {
            throw new IllegalStateException("Alias " + alias + " already exists in namespace " + this.name + ", aliasing " + map.valAt(alias));
        }
    }

    public void removeAlias(Symbol alias) throws Exception {
        IPersistentMap map = this.getAliases();
        while (map.containsKey(alias)) {
            IPersistentMap newMap = map.without(alias);
            this.aliases.compareAndSet(map, newMap);
            map = this.getAliases();
        }
    }
}

