/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IFn;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.LockingTransaction;
import clojure.lang.RT;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ref
implements IFn,
Comparable<Ref>,
IRef {
    TVal tvals = null;
    final AtomicInteger faults = new AtomicInteger();
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    LockingTransaction.Info tinfo = null;
    final UUID uuid = UUID.randomUUID();
    IFn validator;

    @Override
    public int compareTo(Ref o) {
        return this.uuid.compareTo(o.uuid);
    }

    Ref() {
    }

    public Ref(Object initVal) throws Exception {
        this(initVal, null);
    }

    public Ref(Object initVal, IFn validator) throws Exception {
        this();
        if (validator != null) {
            this.validate(validator, initVal);
        }
        this.validator = validator;
        this.tvals = new TVal(initVal, 0L, System.currentTimeMillis());
    }

    public UUID getUUID() {
        return this.uuid;
    }

    Object currentVal() {
        block3: {
            try {
                this.lock.readLock().lock();
                if (this.tvals == null) break block3;
                Object object = this.tvals.val;
                Object var3_2 = null;
                this.lock.readLock().unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.lock.readLock().unlock();
                throw throwable;
            }
        }
        throw new IllegalStateException(this.toString() + " is unbound.");
    }

    @Override
    public Object get() {
        LockingTransaction t = LockingTransaction.getRunning();
        if (t == null) {
            return this.currentVal();
        }
        return t.doGet(this);
    }

    void validate(IFn vf, Object val) {
        try {
            if (vf != null) {
                vf.invoke(val);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalid ref state", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValidator(IFn vf) {
        try {
            this.lock.writeLock().lock();
            this.validate(vf, this.currentVal());
            this.validator = vf;
            Object var3_2 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFn getValidator() {
        try {
            this.lock.readLock().lock();
            IFn iFn = this.validator;
            Object var3_2 = null;
            this.lock.readLock().unlock();
            return iFn;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    public Object set(Object val) {
        return LockingTransaction.getEx().doSet(this, val);
    }

    public Object commute(IFn fn, ISeq args) throws Exception {
        return LockingTransaction.getEx().doCommute(this, fn, args);
    }

    public Object alter(IFn fn, ISeq args) throws Exception {
        LockingTransaction t = LockingTransaction.getEx();
        return t.doSet(this, fn.applyTo(RT.cons(t.doGet(this), args)));
    }

    public void touch() {
        LockingTransaction.getEx().doTouch(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBound() {
        try {
            this.lock.readLock().lock();
            boolean bl = this.tvals != null;
            Object var3_2 = null;
            this.lock.readLock().unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimHistory() {
        try {
            this.lock.writeLock().lock();
            if (this.tvals != null) {
                this.tvals.next = this.tvals;
                this.tvals.prior = this.tvals;
            }
            Object var2_1 = null;
            this.lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.writeLock().unlock();
            throw throwable;
        }
    }

    public final IFn fn() {
        return (IFn)this.get();
    }

    public Object call() throws Exception {
        return this.invoke();
    }

    @Override
    public void run() {
        try {
            this.invoke();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object invoke() throws Exception {
        return this.fn().invoke();
    }

    @Override
    public Object invoke(Object arg1) throws Exception {
        return this.fn().invoke(arg1);
    }

    @Override
    public Object invoke(Object arg1, Object arg2) throws Exception {
        return this.fn().invoke(arg1, arg2);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
    }

    @Override
    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args);
    }

    @Override
    public Object applyTo(ISeq arglist) throws Exception {
        return AFn.applyToHelper(this, arglist);
    }

    public static class TVal {
        Object val;
        long point;
        long msecs;
        TVal prior;
        TVal next;

        TVal(Object val, long point, long msecs, TVal prior) {
            this.val = val;
            this.point = point;
            this.msecs = msecs;
            this.prior = prior;
            this.next = prior.next;
            this.prior.next = this;
            this.next.prior = this;
        }

        TVal(Object val, long point, long msecs) {
            this.val = val;
            this.point = point;
            this.msecs = msecs;
            this.next = this;
            this.prior = this;
        }
    }
}

