/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IPersistentMap;
import clojure.lang.Named;
import clojure.lang.Obj;
import clojure.lang.Util;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class Symbol
extends Obj
implements Comparable,
Named,
Serializable {
    final String ns;
    final String name;
    final int hash;

    public String toString() {
        if (this.ns != null) {
            return this.ns + "/" + this.name;
        }
        return this.name;
    }

    public String getNamespace() {
        return this.ns;
    }

    public String getName() {
        return this.name;
    }

    public static Symbol intern(String ns, String name) {
        return new Symbol(ns == null ? null : ns.intern(), name.intern());
    }

    public static Symbol intern(String nsname) {
        int i = nsname.indexOf(47);
        if (i == -1) {
            return new Symbol(null, nsname.intern());
        }
        return new Symbol(nsname.substring(0, i).intern(), nsname.substring(i + 1).intern());
    }

    public static Symbol create(String name_interned) {
        return new Symbol(null, name_interned);
    }

    public static Symbol create(String ns_interned, String name_interned) {
        return new Symbol(ns_interned, name_interned);
    }

    private Symbol(String ns_interned, String name_interned) {
        this.name = name_interned;
        this.ns = ns_interned;
        this.hash = Util.hashCombine(this.name.hashCode(), Util.hash(this.ns));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Symbol)) {
            return false;
        }
        Symbol symbol = (Symbol)o;
        return this.name == symbol.name && this.ns == symbol.ns;
    }

    public int hashCode() {
        return this.hash;
    }

    public Obj withMeta(IPersistentMap meta) {
        return new Symbol(meta, this.ns, this.name);
    }

    private Symbol(IPersistentMap meta, String ns, String name) {
        super(meta);
        this.name = name;
        this.ns = ns;
        this.hash = Util.hashCombine(name.hashCode(), Util.hash(ns));
    }

    public int compareTo(Object o) {
        Symbol s = (Symbol)o;
        if (this.equals(o)) {
            return 0;
        }
        if (this.ns == null && s.ns != null) {
            return -1;
        }
        if (this.ns != null) {
            if (s.ns == null) {
                return 1;
            }
            int nsc = this.ns.compareTo(s.ns);
            if (nsc != 0) {
                return nsc;
            }
        }
        return this.name.compareTo(s.name);
    }

    private Object readResolve() throws ObjectStreamException {
        return Symbol.intern(this.ns, this.name);
    }
}

