/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentMap;
import clojure.lang.ASeq;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.MapEntry;
import clojure.lang.Obj;
import clojure.lang.PersistentHashMap;
import java.util.Iterator;

public class PersistentArrayMap
extends APersistentMap {
    final Object[] array;
    static final int HASHTABLE_THRESHOLD = 8;
    public static final PersistentArrayMap EMPTY = new PersistentArrayMap();

    protected PersistentArrayMap() {
        this.array = new Object[0];
    }

    public PersistentArrayMap withMeta(IPersistentMap meta) {
        return new PersistentArrayMap(meta, this.array);
    }

    PersistentArrayMap create(Object ... init) {
        return new PersistentArrayMap(this.meta(), init);
    }

    IPersistentMap createHT(Object[] init) {
        return PersistentHashMap.create(this.meta(), init);
    }

    public PersistentArrayMap(Object[] init) {
        this.array = init;
    }

    public PersistentArrayMap(IPersistentMap meta, Object[] init) {
        super(meta);
        this.array = init;
    }

    public int count() {
        return this.array.length / 2;
    }

    public boolean containsKey(Object key) {
        return this.indexOf(key) >= 0;
    }

    public IMapEntry entryAt(Object key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return new MapEntry(key, this.array[i + 1]);
        }
        return null;
    }

    public IPersistentMap assocEx(Object key, Object val) throws Exception {
        int i = this.indexOf(key);
        if (i >= 0) {
            throw new Exception("Key already present");
        }
        if (this.array.length > 8) {
            return this.createHT(this.array).assocEx(key, val);
        }
        Object[] newArray = new Object[this.array.length + 2];
        if (this.array.length > 0) {
            System.arraycopy(this.array, 0, newArray, 2, this.array.length);
        }
        newArray[0] = key;
        newArray[1] = val;
        return this.create(newArray);
    }

    public IPersistentMap assoc(Object key, Object val) {
        Object[] newArray;
        int i = this.indexOf(key);
        if (i >= 0) {
            if (this.array[i + 1] == val) {
                return this;
            }
            newArray = (Object[])this.array.clone();
            newArray[i + 1] = val;
        } else {
            if (this.array.length > 8) {
                return this.createHT(this.array).assoc(key, val);
            }
            newArray = new Object[this.array.length + 2];
            if (this.array.length > 0) {
                System.arraycopy(this.array, 0, newArray, 2, this.array.length);
            }
            newArray[0] = key;
            newArray[1] = val;
        }
        return this.create(newArray);
    }

    public IPersistentMap without(Object key) {
        int i = this.indexOf(key);
        if (i >= 0) {
            int newlen = this.array.length - 2;
            if (newlen == 0) {
                return this.empty();
            }
            Object[] newArray = new Object[newlen];
            int d = 0;
            for (int s = 0; s < this.array.length; s += 2) {
                if (this.equalKey(this.array[s], key)) continue;
                newArray[d] = this.array[s];
                newArray[d + 1] = this.array[s + 1];
                d += 2;
            }
            return this.create(newArray);
        }
        return this;
    }

    public IPersistentMap empty() {
        return EMPTY.withMeta(this.meta());
    }

    public final Object valAt(Object key, Object notFound) {
        int i = this.indexOf(key);
        if (i >= 0) {
            return this.array[i + 1];
        }
        return notFound;
    }

    public Object valAt(Object key) {
        return this.valAt(key, null);
    }

    public int capacity() {
        return this.count();
    }

    private int indexOf(Object key) {
        for (int i = 0; i < this.array.length; i += 2) {
            if (!this.equalKey(this.array[i], key)) continue;
            return i;
        }
        return -1;
    }

    boolean equalKey(Object k1, Object k2) {
        if (k1 == null) {
            return k2 == null;
        }
        return k1.equals(k2);
    }

    public Iterator iterator() {
        return new Iter(this.array);
    }

    public ISeq seq() {
        if (this.array.length > 0) {
            return new Seq(this.array, 0);
        }
        return null;
    }

    static class Iter
    implements Iterator {
        Object[] array;
        int i;

        Iter(Object[] array) {
            this(array, -2);
        }

        Iter(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        public boolean hasNext() {
            return this.i < this.array.length - 2;
        }

        public Object next() {
            this.i += 2;
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Seq
    extends ASeq {
        final Object[] array;
        final int i;

        Seq(Object[] array, int i) {
            this.array = array;
            this.i = i;
        }

        public Seq(IPersistentMap meta, Object[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return new MapEntry(this.array[this.i], this.array[this.i + 1]);
        }

        public ISeq rest() {
            if (this.i + 2 < this.array.length) {
                return new Seq(this.array, this.i + 2);
            }
            return null;
        }

        public int count() {
            return (this.array.length - this.i) / 2;
        }

        public Obj withMeta(IPersistentMap meta) {
            return new Seq(meta, this.array, this.i);
        }
    }
}

