/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IFn;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.LockingTransaction;
import clojure.lang.PersistentQueue;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Var;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

public class Agent
implements IRef {
    volatile Object state;
    AtomicReference<IPersistentStack> q = new AtomicReference<PersistentQueue>(PersistentQueue.EMPTY);
    volatile ISeq errors = null;
    public static final Executor pooledExecutor = Executors.newFixedThreadPool(2 + Runtime.getRuntime().availableProcessors());
    static final Executor soloExecutor = Executors.newCachedThreadPool();
    static final ThreadLocal<IPersistentVector> nested = new ThreadLocal();

    public Agent(Object state) {
        this.setState(state);
    }

    void setState(Object newState) {
        this.state = newState;
    }

    public Object get() throws Exception {
        if (this.errors != null) {
            throw new Exception("Agent has errors", (Exception)RT.first(this.errors));
        }
        return this.state;
    }

    public ISeq getErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors = null;
    }

    public Object dispatch(IFn fn, ISeq args, boolean solo) throws Exception {
        if (this.errors != null) {
            throw new Exception("Agent has errors", (Exception)RT.first(this.errors));
        }
        Action action = new Action(this, fn, args, solo);
        Agent.dispatchAction(action);
        return this;
    }

    static void dispatchAction(Action action) {
        LockingTransaction trans = LockingTransaction.getRunning();
        if (trans != null) {
            trans.enqueue(action);
        } else if (nested.get() != null) {
            nested.set(nested.get().cons(action));
        } else {
            action.agent.enqueue(action);
        }
    }

    void enqueue(Action action) {
        boolean queued = false;
        IPersistentCollection prior = null;
        while (!queued) {
            prior = this.q.get();
            queued = this.q.compareAndSet((IPersistentStack)prior, (IPersistentStack)prior.cons(action));
        }
        if (prior.count() == 0) {
            action.execute();
        }
    }

    static class Action
    implements Runnable {
        final Agent agent;
        final IFn fn;
        final ISeq args;
        final boolean solo;

        public Action(Agent agent, IFn fn, ISeq args, boolean solo) {
            this.agent = agent;
            this.args = args;
            this.fn = fn;
            this.solo = solo;
        }

        void execute() {
            if (this.solo) {
                soloExecutor.execute(this);
            } else {
                pooledExecutor.execute(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void doRun(Action action) {
            try {
                Var.pushThreadBindings(RT.map(RT.AGENT, action.agent));
                nested.set(PersistentVector.EMPTY);
                boolean hadError = false;
                try {
                    action.agent.setState(action.fn.applyTo(RT.cons(action.agent.state, action.args)));
                }
                catch (Exception e) {
                    action.agent.errors = RT.cons(e, action.agent.errors);
                    hadError = true;
                }
                if (!hadError) {
                    for (ISeq s = nested.get().seq(); s != null; s = s.rest()) {
                        Action a = (Action)s.first();
                        a.agent.enqueue(a);
                    }
                }
                boolean popped = false;
                IPersistentCollection next = null;
                while (!popped) {
                    IPersistentStack prior = action.agent.q.get();
                    next = prior.pop();
                    popped = action.agent.q.compareAndSet(prior, (IPersistentStack)next);
                }
                if (next.count() > 0) {
                    ((Action)next.peek()).execute();
                }
            }
            finally {
                nested.set(null);
                Var.popThreadBindings();
            }
        }

        public void run() {
            Action.doRun(this);
        }
    }
}

