/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.IndexedSeq;
import clojure.lang.MapEntry;
import clojure.lang.PersistentVector;
import clojure.lang.RT;
import clojure.lang.Sequential;
import clojure.lang.Util;
import java.util.Collection;
import java.util.Iterator;

public abstract class APersistentVector
extends AFn
implements IPersistentVector,
Iterable,
Collection {
    int _hash = -1;

    public APersistentVector(IPersistentMap meta) {
        super(meta);
    }

    public String toString() {
        return "<vector: - " + this.count() + " items>";
    }

    public ISeq seq() {
        if (this.count() > 0) {
            return new Seq(this, 0);
        }
        return null;
    }

    public ISeq rseq() {
        if (this.count() > 0) {
            return new RSeq(this, this.count() - 1);
        }
        return null;
    }

    static boolean doEquals(IPersistentVector v, Object obj) {
        if (obj instanceof IPersistentVector) {
            IPersistentVector ma = (IPersistentVector)obj;
            if (ma.count() != v.count() || ma.hashCode() != v.hashCode()) {
                return false;
            }
            for (int i = 0; i < v.count(); ++i) {
                if (Util.equal(v.nth(i), ma.nth(i))) continue;
                return false;
            }
        } else {
            if (!(obj instanceof Sequential)) {
                return false;
            }
            ISeq ms = ((IPersistentCollection)obj).seq();
            int i = 0;
            while (i < v.count()) {
                if (ms == null || !Util.equal(v.nth(i), ms.first())) {
                    return false;
                }
                ++i;
                ms = ms.rest();
            }
            if (ms != null) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        return APersistentVector.doEquals(this, obj);
    }

    public int hashCode() {
        if (this._hash == -1) {
            int hash = 0;
            for (int i = 0; i < this.count(); ++i) {
                hash = Util.hashCombine(hash, Util.hash(this.nth(i)));
            }
            this._hash = hash;
        }
        return this._hash;
    }

    public Object invoke(Object arg1) throws Exception {
        return this.nth(((Number)arg1).intValue());
    }

    public Iterator iterator() {
        return new Iterator(){
            int i = 0;

            public boolean hasNext() {
                return this.i < APersistentVector.this.count();
            }

            public Object next() {
                return APersistentVector.this.nth(this.i++);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object peek() {
        if (this.count() > 0) {
            return this.nth(this.count() - 1);
        }
        return null;
    }

    public boolean containsKey(Object key) {
        if (!(key instanceof Number)) {
            return false;
        }
        int i = ((Number)key).intValue();
        return i >= 0 && i < this.count();
    }

    public IMapEntry entryAt(Object key) {
        int i;
        if (key instanceof Number && (i = ((Number)key).intValue()) >= 0 && i < this.count()) {
            return new MapEntry(key, this.nth(i));
        }
        return null;
    }

    public IPersistentVector assoc(Object key, Object val) {
        if (key instanceof Number) {
            int i = ((Number)key).intValue();
            return this.assocN(i, val);
        }
        throw new IllegalArgumentException("Key must be integer");
    }

    public Object valAt(Object key, Object notFound) {
        int i;
        if (key instanceof Number && (i = ((Number)key).intValue()) >= 0 && i < this.count()) {
            return this.nth(i);
        }
        return notFound;
    }

    public Object valAt(Object key) {
        return this.valAt(key, null);
    }

    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (!this.contains(o)) continue;
            return true;
        }
        return false;
    }

    public Object[] toArray(Object[] a) {
        if (a.length >= this.count()) {
            int i = 0;
            for (ISeq s = this.seq(); s != null; s = s.rest()) {
                a[i] = s.first();
                ++i;
            }
            if (a.length >= this.count()) {
                a[this.count()] = null;
            }
            return a;
        }
        return this.toArray();
    }

    public int size() {
        return this.count();
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean contains(Object o) {
        for (ISeq s = this.seq(); s != null; s = s.rest()) {
            if (!Util.equal(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    public int length() {
        return this.count();
    }

    static class SubVector
    extends APersistentVector {
        final IPersistentVector v;
        final int start;
        final int end;

        public SubVector(IPersistentMap meta, IPersistentVector v, int start, int end) {
            super(meta);
            this.v = v;
            this.start = start;
            this.end = end;
        }

        public Object nth(int i) {
            if (this.start + i >= this.end) {
                throw new IndexOutOfBoundsException();
            }
            return this.v.nth(this.start + i);
        }

        public IPersistentVector assocN(int i, Object val) {
            if (this.start + i > this.end) {
                throw new IndexOutOfBoundsException();
            }
            if (this.start + i == this.end) {
                return this.cons(val);
            }
            return new SubVector(this._meta, this.v.assocN(this.start + i, val), this.start, this.end);
        }

        public int count() {
            return this.end - this.start;
        }

        public IPersistentVector cons(Object o) {
            return new SubVector(this._meta, this.v.assocN(this.end, o), this.start, this.end + 1);
        }

        public IPersistentCollection empty() {
            return PersistentVector.EMPTY.withMeta(this.meta());
        }

        public IPersistentStack pop() {
            if (this.end - 1 == this.start) {
                return PersistentVector.EMPTY;
            }
            return new SubVector(this._meta, this.v, this.start, this.end - 1);
        }

        public SubVector withMeta(IPersistentMap meta) {
            if (meta == this._meta) {
                return this;
            }
            return new SubVector(meta, this.v, this.start, this.end);
        }
    }

    static class RSeq
    extends ASeq
    implements IndexedSeq {
        final IPersistentVector v;
        final int i;

        RSeq(IPersistentVector vector, int i) {
            this.v = vector;
            this.i = i;
        }

        RSeq(IPersistentMap meta, IPersistentVector v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        public Object first() {
            return this.v.nth(this.i);
        }

        public ISeq rest() {
            if (this.i > 0) {
                return new RSeq(this.v, this.i - 1);
            }
            return null;
        }

        public int index() {
            return this.i;
        }

        public int count() {
            return this.i + 1;
        }

        public RSeq withMeta(IPersistentMap meta) {
            return new RSeq(meta, this.v, this.i);
        }
    }

    static class Seq
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final IPersistentVector v;
        final int i;

        public Seq(IPersistentVector v, int i) {
            this.v = v;
            this.i = i;
        }

        Seq(IPersistentMap meta, IPersistentVector v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        public Object first() {
            return this.v.nth(this.i);
        }

        public ISeq rest() {
            if (this.i + 1 < this.v.count()) {
                return new Seq(this.v, this.i + 1);
            }
            return null;
        }

        public int index() {
            return this.i;
        }

        public int count() {
            return this.v.count() - this.i;
        }

        public Seq withMeta(IPersistentMap meta) {
            return new Seq(meta, this.v, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.v.nth(this.i);
            for (int x = this.i + 1; x < this.v.count(); ++x) {
                ret = f.invoke(ret, this.v.nth(x));
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.v.nth(this.i));
            for (int x = this.i + 1; x < this.v.count(); ++x) {
                ret = f.invoke(ret, this.v.nth(x));
            }
            return ret;
        }
    }
}

