/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.APersistentVector;
import clojure.lang.Associative;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentCollection;
import clojure.lang.IPersistentStack;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.LazilyPersistentVector;
import clojure.lang.RT;
import clojure.lang.Util;
import java.io.StringWriter;

public abstract class AMapEntry
implements IMapEntry,
IPersistentVector {
    public IPersistentCollection empty() {
        return null;
    }

    public boolean equals(Object obj) {
        return APersistentVector.doEquals(this, obj);
    }

    public int hashCode() {
        return Util.hashCombine(Util.hashCombine(0, Util.hash(this.key())), Util.hash(this.val()));
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            RT.print(this, sw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public int length() {
        return 2;
    }

    public Object nth(int i) {
        if (i == 0) {
            return this.key();
        }
        if (i == 1) {
            return this.val();
        }
        throw new IndexOutOfBoundsException();
    }

    private IPersistentVector asVector() {
        return LazilyPersistentVector.createOwning(this.key(), this.val());
    }

    public IPersistentVector assocN(int i, Object val) {
        return this.asVector().assocN(i, val);
    }

    public int count() {
        return 2;
    }

    public ISeq seq() {
        return this.asVector().seq();
    }

    public IPersistentVector cons(Object o) {
        return this.asVector().cons(o);
    }

    public boolean containsKey(Object key) {
        return this.asVector().containsKey(key);
    }

    public IMapEntry entryAt(Object key) {
        return this.asVector().entryAt(key);
    }

    public Associative assoc(Object key, Object val) {
        return this.asVector().assoc(key, val);
    }

    public Object valAt(Object key) {
        return this.asVector().valAt(key);
    }

    public Object valAt(Object key, Object notFound) {
        return this.asVector().valAt(key, notFound);
    }

    public Object peek() {
        return this.val();
    }

    public IPersistentStack pop() {
        return LazilyPersistentVector.createOwning(this.key());
    }

    public ISeq rseq() throws Exception {
        return this.asVector().rseq();
    }
}

