/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.IndexedSeq;
import clojure.lang.Reflector;
import java.lang.reflect.Array;

public class ArraySeq
extends ASeq
implements IndexedSeq,
IReduce {
    final Object array;
    final int i;
    final Object[] oa;

    public static ArraySeq create() {
        return null;
    }

    public static ArraySeq create(Object ... array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return new ArraySeq(array, 0);
    }

    static ISeq createFromObject(Object array) {
        if (array == null || Array.getLength(array) == 0) {
            return null;
        }
        Class<?> aclass = array.getClass();
        if (aclass == int[].class) {
            return new ArraySeq_int(null, (int[])array, 0);
        }
        if (aclass == float[].class) {
            return new ArraySeq_float(null, (float[])array, 0);
        }
        if (aclass == double[].class) {
            return new ArraySeq_double(null, (double[])array, 0);
        }
        if (aclass == long[].class) {
            return new ArraySeq_long(null, (long[])array, 0);
        }
        return new ArraySeq(array, 0);
    }

    ArraySeq(Object array, int i) {
        this.array = array;
        this.i = i;
        this.oa = (Object[])(array instanceof Object[] ? array : null);
    }

    ArraySeq(IPersistentMap meta, Object array, int i) {
        super(meta);
        this.array = array;
        this.i = i;
        this.oa = (Object[])(array instanceof Object[] ? array : null);
    }

    public Object first() {
        if (this.oa != null) {
            return this.oa[this.i];
        }
        return Reflector.prepRet(Array.get(this.array, this.i));
    }

    public ISeq next() {
        if (this.oa != null ? this.i + 1 < this.oa.length : this.i + 1 < Array.getLength(this.array)) {
            return new ArraySeq(this.array, this.i + 1);
        }
        return null;
    }

    public int count() {
        if (this.oa != null) {
            return this.oa.length - this.i;
        }
        return Array.getLength(this.array) - this.i;
    }

    public int index() {
        return this.i;
    }

    public ArraySeq withMeta(IPersistentMap meta) {
        return new ArraySeq(meta, this.array, this.i);
    }

    public Object reduce(IFn f) throws Exception {
        if (this.oa != null) {
            Object ret = this.oa[this.i];
            for (int x = this.i + 1; x < this.oa.length; ++x) {
                ret = f.invoke(ret, this.oa[x]);
            }
            return ret;
        }
        Object ret = Reflector.prepRet(Array.get(this.array, this.i));
        for (int x = this.i + 1; x < Array.getLength(this.array); ++x) {
            ret = f.invoke(ret, Reflector.prepRet(Array.get(this.array, x)));
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) throws Exception {
        if (this.oa != null) {
            Object ret = f.invoke(start, this.oa[this.i]);
            for (int x = this.i + 1; x < this.oa.length; ++x) {
                ret = f.invoke(ret, this.oa[x]);
            }
            return ret;
        }
        Object ret = f.invoke(start, Reflector.prepRet(Array.get(this.array, this.i)));
        for (int x = this.i + 1; x < Array.getLength(this.array); ++x) {
            ret = f.invoke(ret, Reflector.prepRet(Array.get(this.array, x)));
        }
        return ret;
    }

    public static class ArraySeq_long
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final long[] array;
        final int i;

        ArraySeq_long(IPersistentMap meta, long[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_long(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_long withMeta(IPersistentMap meta) {
            return new ArraySeq_long(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }
    }

    public static class ArraySeq_double
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final double[] array;
        final int i;

        ArraySeq_double(IPersistentMap meta, double[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_double(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_double withMeta(IPersistentMap meta) {
            return new ArraySeq_double(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }
    }

    public static class ArraySeq_float
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final float[] array;
        final int i;

        ArraySeq_float(IPersistentMap meta, float[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return Float.valueOf(this.array[this.i]);
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_float(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_float withMeta(IPersistentMap meta) {
            return new ArraySeq_float(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = Float.valueOf(this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Float.valueOf(this.array[x]));
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, Float.valueOf(this.array[this.i]));
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, Float.valueOf(this.array[x]));
            }
            return ret;
        }
    }

    public static class ArraySeq_int
    extends ASeq
    implements IndexedSeq,
    IReduce {
        final int[] array;
        final int i;

        ArraySeq_int(IPersistentMap meta, int[] array, int i) {
            super(meta);
            this.array = array;
            this.i = i;
        }

        public Object first() {
            return this.array[this.i];
        }

        public ISeq next() {
            if (this.i + 1 < this.array.length) {
                return new ArraySeq_int(this.meta(), this.array, this.i + 1);
            }
            return null;
        }

        public int count() {
            return this.array.length - this.i;
        }

        public int index() {
            return this.i;
        }

        public ArraySeq_int withMeta(IPersistentMap meta) {
            return new ArraySeq_int(meta, this.array, this.i);
        }

        public Object reduce(IFn f) throws Exception {
            Object ret = this.array[this.i];
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }

        public Object reduce(IFn f, Object start) throws Exception {
            Object ret = f.invoke(start, this.array[this.i]);
            for (int x = this.i + 1; x < this.array.length; ++x) {
                ret = f.invoke(ret, this.array[x]);
            }
            return ret;
        }
    }
}

