/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ARef;
import clojure.lang.Associative;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.Namespace;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Settable;
import clojure.lang.Symbol;
import clojure.lang.Util;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Var
extends ARef
implements IFn,
IRef,
Settable {
    static final ThreadLocal<Frame> dvals = new ThreadLocal<Frame>(){

        @Override
        protected Frame initialValue() {
            return new Frame();
        }
    };
    public static volatile int rev = 0;
    static Keyword privateKey = Keyword.intern(null, "private");
    static IPersistentMap privateMeta = new PersistentArrayMap(new Object[]{privateKey, Boolean.TRUE});
    static Keyword macroKey = Keyword.intern(null, "macro");
    static Keyword nameKey = Keyword.intern(null, "name");
    static Keyword nsKey = Keyword.intern(null, "ns");
    volatile Object root;
    volatile boolean dynamic = false;
    final transient AtomicBoolean threadBound;
    public final Symbol sym;
    public final Namespace ns;
    static IFn assoc = new AFn(){

        public Object invoke(Object m, Object k, Object v) {
            return RT.assoc(m, k, v);
        }
    };
    static IFn dissoc = new AFn(){

        public Object invoke(Object c, Object k) {
            try {
                return RT.dissoc(c, k);
            }
            catch (Exception e) {
                throw Util.sneakyThrow(e);
            }
        }
    };

    public static Object getThreadBindingFrame() {
        Frame f = dvals.get();
        if (f != null) {
            return f;
        }
        return new Frame();
    }

    public static Object cloneThreadBindingFrame() {
        Frame f = dvals.get();
        if (f != null) {
            return f.clone();
        }
        return new Frame();
    }

    public static void resetThreadBindingFrame(Object frame) {
        dvals.set((Frame)frame);
    }

    public Var setDynamic() {
        this.dynamic = true;
        return this;
    }

    public Var setDynamic(boolean b) {
        this.dynamic = b;
        return this;
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    public static Var intern(Namespace ns, Symbol sym, Object root) {
        return Var.intern(ns, sym, root, true);
    }

    public static Var intern(Namespace ns, Symbol sym, Object root, boolean replaceRoot) {
        Var dvout = ns.intern(sym);
        if (!dvout.hasRoot() || replaceRoot) {
            dvout.bindRoot(root);
        }
        return dvout;
    }

    public String toString() {
        if (this.ns != null) {
            return "#'" + this.ns.name + "/" + this.sym;
        }
        return "#<Var: " + (this.sym != null ? this.sym.toString() : "--unnamed--") + ">";
    }

    public static Var find(Symbol nsQualifiedSym) {
        if (nsQualifiedSym.ns == null) {
            throw new IllegalArgumentException("Symbol must be namespace-qualified");
        }
        Namespace ns = Namespace.find(Symbol.intern(nsQualifiedSym.ns));
        if (ns == null) {
            throw new IllegalArgumentException("No such namespace: " + nsQualifiedSym.ns);
        }
        return ns.findInternedVar(Symbol.intern(nsQualifiedSym.name));
    }

    public static Var intern(Symbol nsName, Symbol sym) {
        Namespace ns = Namespace.findOrCreate(nsName);
        return Var.intern(ns, sym);
    }

    public static Var internPrivate(String nsName, String sym) {
        Namespace ns = Namespace.findOrCreate(Symbol.intern(nsName));
        Var ret = Var.intern(ns, Symbol.intern(sym));
        ret.setMeta(privateMeta);
        return ret;
    }

    public static Var intern(Namespace ns, Symbol sym) {
        return ns.intern(sym);
    }

    public static Var create() {
        return new Var(null, null);
    }

    public static Var create(Object root) {
        return new Var(null, null, root);
    }

    Var(Namespace ns, Symbol sym) {
        this.ns = ns;
        this.sym = sym;
        this.threadBound = new AtomicBoolean(false);
        this.root = new Unbound(this);
        this.setMeta(PersistentHashMap.EMPTY);
    }

    Var(Namespace ns, Symbol sym, Object root) {
        this(ns, sym);
        this.root = root;
        ++rev;
    }

    public boolean isBound() {
        return this.hasRoot() || this.threadBound.get() && Var.dvals.get().bindings.containsKey(this);
    }

    public final Object get() {
        if (!this.threadBound.get()) {
            return this.root;
        }
        return this.deref();
    }

    public final Object deref() {
        TBox b = this.getThreadBinding();
        if (b != null) {
            return b.val;
        }
        return this.root;
    }

    public void setValidator(IFn vf) {
        if (this.hasRoot()) {
            this.validate(vf, this.root);
        }
        this.validator = vf;
    }

    public Object alter(IFn fn, ISeq args) {
        this.set(fn.applyTo(RT.cons(this.deref(), args)));
        return this;
    }

    public Object set(Object val) {
        this.validate(this.getValidator(), val);
        TBox b = this.getThreadBinding();
        if (b != null) {
            if (Thread.currentThread() != b.thread) {
                throw new IllegalStateException(String.format("Can't set!: %s from non-binding thread", this.sym));
            }
            b.val = val;
            return b.val;
        }
        throw new IllegalStateException(String.format("Can't change/establish root binding of: %s with set", this.sym));
    }

    public Object doSet(Object val) {
        return this.set(val);
    }

    public Object doReset(Object val) {
        this.bindRoot(val);
        return val;
    }

    public void setMeta(IPersistentMap m) {
        this.resetMeta(m.assoc(nameKey, this.sym).assoc(nsKey, this.ns));
    }

    public void setMacro() {
        try {
            this.alterMeta(assoc, RT.list(macroKey, RT.T));
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
    }

    public boolean isMacro() {
        return RT.booleanCast(this.meta().valAt(macroKey));
    }

    public boolean isPublic() {
        return !RT.booleanCast(this.meta().valAt(privateKey));
    }

    public final Object getRawRoot() {
        return this.root;
    }

    public Object getTag() {
        return this.meta().valAt(RT.TAG_KEY);
    }

    public void setTag(Symbol tag) {
        try {
            this.alterMeta(assoc, RT.list(RT.TAG_KEY, tag));
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
    }

    public final boolean hasRoot() {
        return !(this.root instanceof Unbound);
    }

    public synchronized void bindRoot(Object root) {
        this.validate(this.getValidator(), root);
        Object oldroot = this.root;
        this.root = root;
        ++rev;
        try {
            this.alterMeta(dissoc, RT.list(macroKey));
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
        this.notifyWatches(oldroot, this.root);
    }

    synchronized void swapRoot(Object root) {
        this.validate(this.getValidator(), root);
        Object oldroot = this.root;
        this.root = root;
        ++rev;
        this.notifyWatches(oldroot, root);
    }

    public synchronized void unbindRoot() {
        this.root = new Unbound(this);
        ++rev;
    }

    public synchronized void commuteRoot(IFn fn) {
        Object newRoot = fn.invoke(this.root);
        this.validate(this.getValidator(), newRoot);
        Object oldroot = this.root;
        this.root = newRoot;
        ++rev;
        this.notifyWatches(oldroot, newRoot);
    }

    public synchronized Object alterRoot(IFn fn, ISeq args) {
        Object newRoot = fn.applyTo(RT.cons(this.root, args));
        this.validate(this.getValidator(), newRoot);
        Object oldroot = this.root;
        this.root = newRoot;
        ++rev;
        this.notifyWatches(oldroot, newRoot);
        return newRoot;
    }

    public static void pushThreadBindings(Associative bindings) {
        Frame f = dvals.get();
        Associative bmap = f.bindings;
        for (ISeq bs = bindings.seq(); bs != null; bs = bs.next()) {
            IMapEntry e = (IMapEntry)bs.first();
            Var v = (Var)e.key();
            if (!v.dynamic) {
                throw new IllegalStateException(String.format("Can't dynamically bind non-dynamic var: %s/%s", v.ns, v.sym));
            }
            v.validate(v.getValidator(), e.val());
            v.threadBound.set(true);
            bmap = bmap.assoc(v, new TBox(Thread.currentThread(), e.val()));
        }
        dvals.set(new Frame(bmap, f));
    }

    public static void popThreadBindings() {
        Frame f = dvals.get();
        if (f.prev == null) {
            throw new IllegalStateException("Pop without matching push");
        }
        dvals.set(f.prev);
    }

    public static Associative getThreadBindings() {
        Frame f = dvals.get();
        IPersistentMap ret = PersistentHashMap.EMPTY;
        for (ISeq bs = f.bindings.seq(); bs != null; bs = bs.next()) {
            IMapEntry e = (IMapEntry)bs.first();
            Var v = (Var)e.key();
            TBox b = (TBox)e.val();
            ret = ret.assoc(v, b.val);
        }
        return ret;
    }

    public final TBox getThreadBinding() {
        IMapEntry e;
        if (this.threadBound.get() && (e = Var.dvals.get().bindings.entryAt(this)) != null) {
            return (TBox)e.val();
        }
        return null;
    }

    public final IFn fn() {
        return (IFn)this.deref();
    }

    public Object call() {
        return this.invoke();
    }

    public void run() {
        try {
            this.invoke();
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
    }

    public Object invoke() {
        return this.fn().invoke();
    }

    public Object invoke(Object arg1) {
        return this.fn().invoke(arg1);
    }

    public Object invoke(Object arg1, Object arg2) {
        return this.fn().invoke(arg1, arg2);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3) {
        return this.fn().invoke(arg1, arg2, arg3);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.fn().invoke(arg1, arg2, arg3, arg4);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args);
    }

    public Object applyTo(ISeq arglist) {
        return AFn.applyToHelper(this, arglist);
    }

    static class Frame {
        Associative bindings;
        Frame prev;

        public Frame() {
            this(PersistentHashMap.EMPTY, null);
        }

        public Frame(Associative bindings, Frame prev) {
            this.bindings = bindings;
            this.prev = prev;
        }

        protected Object clone() {
            Frame f = new Frame();
            f.bindings = this.bindings;
            return f;
        }
    }

    public static class Unbound
    extends AFn {
        public final Var v;

        public Unbound(Var v) {
            this.v = v;
        }

        public String toString() {
            return "Unbound: " + this.v;
        }

        public Object throwArity(int n) {
            throw new IllegalStateException("Attempting to call unbound fn: " + this.v);
        }
    }

    static class TBox {
        volatile Object val;
        final Thread thread;

        public TBox(Thread t, Object val) {
            this.thread = t;
            this.val = val;
        }
    }
}

