/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IPersistentVector;
import clojure.lang.ISeq;
import clojure.lang.ITransientMap;
import clojure.lang.RT;
import java.util.Map;

abstract class ATransientMap
extends AFn
implements ITransientMap {
    ATransientMap() {
    }

    abstract void ensureEditable();

    abstract ITransientMap doAssoc(Object var1, Object var2);

    abstract ITransientMap doWithout(Object var1);

    abstract Object doValAt(Object var1, Object var2);

    abstract int doCount();

    abstract IPersistentMap doPersistent();

    public ITransientMap conj(Object o) {
        this.ensureEditable();
        if (o instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)o;
            return this.assoc(e.getKey(), e.getValue());
        }
        if (o instanceof IPersistentVector) {
            IPersistentVector v = (IPersistentVector)o;
            if (v.count() != 2) {
                throw new IllegalArgumentException("Vector arg to map conj must be a pair");
            }
            return this.assoc(v.nth(0), v.nth(1));
        }
        ITransientMap ret = this;
        for (ISeq es = RT.seq(o); es != null; es = es.next()) {
            Map.Entry e = (Map.Entry)es.first();
            ret = ret.assoc(e.getKey(), e.getValue());
        }
        return ret;
    }

    public final Object invoke(Object arg1) {
        return this.valAt(arg1);
    }

    public final Object invoke(Object arg1, Object notFound) {
        return this.valAt(arg1, notFound);
    }

    public final Object valAt(Object key) {
        return this.valAt(key, null);
    }

    public final ITransientMap assoc(Object key, Object val) {
        this.ensureEditable();
        return this.doAssoc(key, val);
    }

    public final ITransientMap without(Object key) {
        this.ensureEditable();
        return this.doWithout(key);
    }

    public final IPersistentMap persistent() {
        this.ensureEditable();
        return this.doPersistent();
    }

    public final Object valAt(Object key, Object notFound) {
        this.ensureEditable();
        return this.doValAt(key, notFound);
    }

    public final int count() {
        this.ensureEditable();
        return this.doCount();
    }
}

