/*
 * Decompiled with CFR 0.152.
 */
package clojure.core;

import clojure.core.ArrayManager;
import clojure.lang.IChunk;
import clojure.lang.IFn;
import clojure.lang.Indexed;
import clojure.lang.Numbers;
import clojure.lang.RT;
import clojure.lang.Util;
import clojure.lang.Var;

public final class ArrayChunk
implements Indexed,
IChunk {
    public static final Var const__0 = RT.var("clojure.core", "=");
    public static final Var const__1 = RT.var("clojure.core", "inc");
    public static final Var const__2 = RT.var("clojure.core", "loop");
    public static final Var const__3 = RT.var("clojure.core", "<");
    public static final Var const__4 = RT.var("clojure.core", "+");
    public static final Var const__5 = RT.var("clojure.core", "-");
    public final Object am;
    public final Object arr;
    public final int off;
    public final int end;

    public ArrayChunk(Object object, Object object2, int n, int n2) {
        this.am = object;
        this.arr = object2;
        this.off = n;
        this.end = n2;
    }

    public int count() {
        return Numbers.minus(this.end, this.off);
    }

    public Object nth(int i) {
        return ((ArrayManager)this.am).aget(this.arr, Numbers.add(this.off, i));
    }

    public Object reduce(IFn f, Object init) throws Exception {
        Object object = init;
        init = null;
        Object object2 = object;
        int i = this.off;
        while (Numbers.lt(i, this.end)) {
            Object ret;
            Object object3 = f.invoke(ret, ((ArrayManager)this.am).aget(this.arr, i));
            i = Numbers.inc(i);
            ret = object3;
        }
        return object2;
    }

    public IChunk dropFirst() {
        if (Util.equiv(this.off, this.end)) {
            throw (Throwable)new IllegalStateException("dropFirst of empty chunk");
        }
        return new ArrayChunk(this.am, this.arr, Numbers.inc(this.off), this.end);
    }
}

