/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Ref;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionalHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    final Ref[] bins;

    IPersistentMap mapAt(int bin) {
        return (IPersistentMap)this.bins[bin].deref();
    }

    final int binFor(Object k) {
        int h = k.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h % this.bins.length;
    }

    Map.Entry entryAt(Object k) {
        return this.mapAt(this.binFor(k)).entryAt(k);
    }

    public TransactionalHashMap() throws Exception {
        this(421);
    }

    public TransactionalHashMap(int nBins) throws Exception {
        this.bins = new Ref[nBins];
        for (int i = 0; i < nBins; ++i) {
            this.bins[i] = new Ref((Object)PersistentHashMap.EMPTY);
        }
    }

    public TransactionalHashMap(Map<? extends K, ? extends V> m) throws Exception {
        this(m.size());
        this.putAll(m);
    }

    @Override
    public int size() {
        int n = 0;
        for (int i = 0; i < this.bins.length; ++i) {
            n += this.mapAt(i).count();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.entryAt(k) != null;
    }

    @Override
    public V get(Object k) {
        Map.Entry e = this.entryAt(k);
        if (e != null) {
            return e.getValue();
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        Object ret = map.valAt(k);
        r.set(map.assoc(k, v));
        return (V)ret;
    }

    @Override
    public V remove(Object k) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        Object ret = map.valAt(k);
        try {
            r.set(map.without(k));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (V)ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.bins.length; ++i) {
            Ref r = this.bins[i];
            IPersistentMap map = (IPersistentMap)r.deref();
            if (map.count() <= 0) continue;
            r.set(PersistentHashMap.EMPTY);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final ArrayList entries = new ArrayList(this.bins.length);
        for (int i = 0; i < this.bins.length; ++i) {
            IPersistentMap map = this.mapAt(i);
            if (map.count() <= 0) continue;
            entries.addAll((Collection)((Object)RT.seq(map)));
        }
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator iterator() {
                return Collections.unmodifiableList(entries).iterator();
            }

            @Override
            public int size() {
                return entries.size();
            }
        };
    }

    @Override
    public V putIfAbsent(K k, V v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e == null) {
            r.set(map.assoc(k, v));
            return null;
        }
        return e.getValue();
    }

    @Override
    public boolean remove(Object k, Object v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e != null && e.getValue().equals(v)) {
            try {
                r.set(map.without(k));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K k, V oldv, V newv) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e != null && e.getValue().equals(oldv)) {
            r.set(map.assoc(k, newv));
            return true;
        }
        return false;
    }

    @Override
    public V replace(K k, V v) {
        Ref r = this.bins[this.binFor(k)];
        IPersistentMap map = (IPersistentMap)r.deref();
        IMapEntry e = map.entryAt(k);
        if (e != null) {
            r.set(map.assoc(k, v));
            return e.getValue();
        }
        return null;
    }
}

