/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.IChunk;
import clojure.lang.IFn;

public final class ArrayChunk
implements IChunk {
    final Object[] array;
    final int off;
    final int end;

    public ArrayChunk(Object[] array) {
        this(array, 0, array.length);
    }

    public ArrayChunk(Object[] array, int off) {
        this(array, off, array.length);
    }

    public ArrayChunk(Object[] array, int off, int end) {
        this.array = array;
        this.off = off;
        this.end = end;
    }

    public Object nth(int i) {
        return this.array[this.off + i];
    }

    public int count() {
        return this.end - this.off;
    }

    public IChunk dropFirst() {
        if (this.off == this.end) {
            throw new IllegalStateException("dropFirst of empty chunk");
        }
        return new ArrayChunk(this.array, this.off + 1, this.end);
    }

    public Object reduce(IFn f, Object start) throws Exception {
        Object ret = f.invoke(start, this.array[this.off]);
        for (int x = this.off + 1; x < this.end; ++x) {
            ret = f.invoke(ret, this.array[x]);
        }
        return ret;
    }
}

