<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * CHeMS functions
*/

/*
 * Modules return values
*/
define("CHEMS_MODULE_FAILURE", -201);

/*
 * Return a module
*/
function getModFunc($modname, $suffix)
{
   // Get the module file name
   $f = PATH_MODULES."$modname/$modname.php";

   // Check if the file doesn't exist
   // (the code talk by itself - yes, it's geek :-))
   if( ! file_exists($f) )
      return;

   // Include the module code
   require_once($f);

   // $f is now the module's main function
   $f = "$modname$suffix";
   $module = $f(); // Load the module

   // Module returned with an error code
   if( $module === CHEMS_MODULE_FAILURE )
      return str_replace("%[modname]", $modname, MODULES_MSG_ERROR);

   return $module;
} /* eof getModFunc() */

/*
 * Load the given theme.
 * This allow to change the theme on-the-fly.
*/
function themeLoad($theme_name)
{
   // Check if the user don't want any theme
   if( $theme_name === "none" )
      return;

   global $THEME; // Make theme informations accessible from main.php

   // Get the theme values
   require_once(PATH_THEMES."$theme_name/$theme_name.theme");
}

/*
 * Check if the module $modname is included among the
 * elements of the $modlist modules list (in which case
 * it has been exlicitally loaded by the user) and return
 * true if it's present or false if it's not found.
*/
function modisload($modlist, $modname)
{

   // Traverse the $modlist array
   for($mod = 0; isset($modlist[$mod]) && ($module = $modlist[$mod]); $mod++) {
      if( $module["name"] === $modname )
         return true; // Module found
   }

   return false; // Not found
} /* eof modisload() */

/*
 * Check if the given value "$value" is an element of
 * the fields list provided with the string "$string"
 * and return true if it's found, else return false.
*/
function istoggled($string, $value)
{

   // Get the options array
   $elements = split(FSL, $string);

   // Look for the value
   foreach($elements as $cval) {
      if( $cval === $value || $cval == "all" )
         return true;
   }

   return false;
} /* eof istoggled() */

/*
 * Add a module into the modules list
*/
function modload($name, $side, $mods, $opts="")
{
   global $MODULES;

   // Ignore wrong declarations
   if( ! $name )
      return;

   $id = sizeof($MODULES);

   // Store the mandatory informations
   $MODULES[$id]["name"] = $name;

   // Allow to load unshowed modules
   if( $side !== "none" && $mods !== "none" ) {
      $MODULES[$id]["side"] = $side;
      $MODULES[$id]["mods"] = $mods;
   }

   // Optionals informations
   if( $opts ) {
      foreach($opts as $opt => $val)
         $MODULES[$id][$opt] = $val;
   }

} /* eof modload() */

?>
