<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Showfile module
*/

/*
 * This code has been wrote quite quickly, this is mean that
 * much probably it contain some bug. Though i tried to insert
 * as much comments as possible it's not very readable but
 * since this is not a definitive release of the module (it's
 * a development version indeed) i'll try to improve it a lot
 * before to publish it as official CHeMS "showfiles" module.
*/

/*
 * The CHeMS module get function
*/
function showfiles_main() {
   global $module;
   global $MOD_SHOWFILES_PATHS;

   // If no paths or more instances return an error
   if( ! sizeof($MOD_SHOWFILES_PATHS) || $module->instid )
      return CHEMS_MODULE_FAILURE;

   $ret = "
      <div id='mod_showfiles_main' class='chems_module'>
         <div class='chems_module_title'>".@constant("MOD_SHOWFILES_TITLE$instpfx")."</div>
         <div class='chems_module_body'>";

   // Link all the paths
   for($p = 0; isset($MOD_SHOWFILES_PATHS[$p]) && ($path = $MOD_SHOWFILES_PATHS[$p]); $p++) {
      $ret .= "
         <a href='".WEBROOT."?modname=showfiles&amp;id=$p&amp;path=$path[1]'>$path[0]</a>
        <br />
      ";
   }

   // Close the divs
   $ret .= "
	 </div>
      </div>
   ";

   return str_replace("%[dirs]", $p, $ret); 
} /* eof showfiles_main() */

/*
 * The CHeMS module page function
*/
function showfiles_page()
{
   global $MOD_SHOWFILES_PATHS;

   $id = ( isset($_GET['id']) ? $_GET['id'] : -1); // Request ID

   // If no ID show the list
   if( $id == -1 )
      return showfiles_list();

   // Check if the given ID is in the list
   else if( ! isset($MOD_SHOWFILES_PATHS[$id]) )
      return MOD_SHOWFILES_MSG_INVID;

   /*
    * Okay, security issue.
    * It's important to force the user to have a logical root different
    * from the real system root (hopeful '/' :-)). Since it's impossible
    * to put it into a chroot jail i have to check the level of the
    * requested directory in order to ensure that it's not a higher level
    * directory from the path specified into the modconf.php file (see
    * the $MOD_SHOWFILES_PATHS array).
   */

   $curpath = $_GET['path'];			// Current path
   $path = $MOD_SHOWFILES_PATHS[$id][1];	// Root path (from modconf.php)

   /*
    * Return with an error message if:
    *
    *    . path is a parent (or at least the "brother") of the given path;
    *    . path contains the ".." string;
    *    . the specified path (that in modconf.php) is equal to the ".." string.
   */
   if( strcmp($path, substr($curpath, 0, strlen($path))) ||
       strpos($curpath, "..") || $path === ".." )
      return MOD_SHOWFILES_MSG_EPERM;

   // Get the parent directory
   $plink = getplink($path, $curpath, $id);

   $FO = array(
      "%[linked_path]",
      "%[uplink]",
   );

   $FOEXP = array(
      linkpath($path, $curpath, $id),
      $plink,
   );

   // Add the header informations (expands the format operators)
   $page = "
      <div class='chems_module'>
         <div class='chems_module_title'>".$MOD_SHOWFILES_PATHS[$id][0]."</div>

         <div id='showfiles_list_$id'>
	    ".str_replace($FO, $FOEXP, MOD_SHOWFILES_PAGEHEAD)."
   ";

   // Select the type of list and call the relative function.
   $page .= showfiles_print($id, $path, $curpath);

   // Close the module's div
   $page .= "
         </div>
      </div>
   ";

   return $page;
} /* eof showfiles_page() */

/*
 * Internal routines (which are not called directly from CHeMS)
*/

/*
 * Create the body of the "showfiles" module page including the
 * header and "footer" informations. The function generate the
 * name of the printing function from the MOD_SHOWFILES_LSTYPE
 * value and return the text generated from a call to this "new"
 * function. Finally return the whole page to the caller.
*/
function showfiles_print($id, $path, $curpath)
{

   // It's not a directory (or not exists)
   if( ! is_dir($curpath) )
      return MOD_SHOWFILES_WRONGDIR;

   // Generate the files list
   if( ! ($filetot = getfileslist($list, $curpath)) )
      return MOD_SHOWFILES_EMPTYDIR;

   // Add some stat (up)
   if( MOD_SHOWFILES_INFOPOS === "up" || MOD_SHOWFILES_INFOPOS === "both" )
      showfiles_stat($page, $filetot);

   // Create the function name and call it
   $func = "showfiles_ls".@constant("MOD_SHOWFILES_LSTYPE$instpfx");
   $page = $func($list, $id, $curpath);

   // Add some stat (down)
   if( MOD_SHOWFILES_INFOPOS === "down" || MOD_SHOWFILES_INFOPOS === "both" )
      showfiles_stat($page, $filetot);

   return $page;
} /* eof showfiles_print() */

/*
 * Generate a list of all files. Each file is preceding by
 * one or more flag which identify the file type (regular
 * file, directory, link, etc.). The files are linked to
 * their relative path. If a file is unreadable it's still
 * shown but not linked.
*/
function showfiles_lslist($list, $id, $curpath)
{

   // Show the files
   foreach($list as $file) {

      // Get the complete path
      $cp_file = "$curpath/$file";

      // It's a symlink
      if( is_link($cp_file) ) {

	 $type = "*";
	 $cp_file = readlink($cp_file); // Get the complete (real) path
      }
      else
         $type = "";

      // Get the flag
      if( is_file($cp_file) )
	 $type .= "F";	// File
      else if( is_dir($cp_file) )
         $type .= "D";	// Directory
      else
         $type .= "U"; 	// Unknown object

      // Add the link, maybe
      if( is_readable($cp_file) ) {
         switch( $type[0] ) {
            case 'D': // directory
            case '*': // symlink
               $link = "?modname=showfiles&amp;id=$id&amp;path=$cp_file";
   	       break;
	    case 'F': // file
               $link = WEBROOT.$cp_file;
	       break;
         }

	 // Show the file
	 $text .= "[$type] " . (MOD_SHOWFILES_LINK ?
	          "<a href='$link'>$file</a>" : $file) .
		  "<br />";
      }
      else {
         // The file is unreadable: add the 'u' character as type flag
	 $type .= "u";
         $text .= "[$type] $file<br />";
      }

   }

   return $text;
} /* eof showfiles_lslist() */

/*
 * Get all files of the specified directory and return the number
 * of total files found. The array $list is populate with the list
 * of these, if any, else zero is returned and nothing is done.
*/
function getfileslist(&$list, $path)
{
   $ftot = $dtot = 0;
   $dirs = $files = array();

   $d = dir($path);	// Open the directory

   // Read it (get "all" files)
   while (($filecur = $d->read()) !== False) {

      // Ignore the directories '.' and ".." and apply the user filters
      if( ($filecur === '.' || $filecur === "..") || preg_match(MOD_SHOWFILES_HIDE, $filecur) ||
          (is_link($filecur) && ! MOD_SHOWFILES_SYMLINK) )
         continue;

      // Forward by type
      if( is_dir($path.'/'.$filecur) )
         $dirs[$dtot++] = $filecur;
      else
         $files[$ftot++] = $filecur;
      
   }

   $d->close();	// Close the directory

   // Sort the list (directories first)
   if( MOD_SHOWFILES_SORT ) {
      if( $dtot ) sort($dirs);
      if( $ftot ) sort($files);
   }

   // Merge the lists
   $list = array_merge((array)$dirs, (array)$files);

   return ($dtot + $ftot);
} /* eof getfileslist() */

/*
 * Add some information about the current listing
*/
function showfiles_stat(&$text, $file_tot)
{
   $text .= str_replace("%[files_tot]", $file_tot, MOD_SHOWFILES_INFO) . "<br />";
} /* eof showfiles_stat() */

/*
 * Check if the current path is not the same as the root
 * path for this ID in which case return a link to the
 * parent directory. If the current and the root
 * directories are the same an empty string is returned.
*/
function getplink($path, $curpath, $id)
{
   global $module;

   // Generate the instance postfix
   $instpfx = (isset($module->istance) && $module->instance ? $instpfx = "_".strtoupper($module->instance) : '');

   // Store the current instance option
   $sf_plname = @constant("MOD_SHOWFILES_PLNAME".$instpfx);

   $plink = strcmp($path, $curpath) ?
      $plink = "<a href='?modname=showfiles&amp;id=$id&amp;path=".substr($curpath, 0, strrpos($curpath, "/"))."'>$sf_plname</a>" :
      '';

   return $plink;
} /* getplink() */

/*
 * Links each directory of the current path and return
 * the so generated full path
*/
function linkpath($path, $curpath, $id)
{

   // Get an array with the directories of the current path
   $dirs = split("/", $curpath);

   // Links the directories
   for($d = 0, $next_path = $linked_path = ''; isset($dirs[$d]); $d++) {

      // Add the next directory to the path (incremental)
      $next_path .= ($d ? '/' : '') . "$dirs[$d]";

      if( strpos($next_path, $path) !== False ) {
         // Links the last directory in the path
         $linked_path .= "<a href='?modname=showfiles&amp;id=$id&amp;path=$next_path'>$dirs[$d]</a>/";
      }
      else
         $linked_path .= "$dirs[$d]/";

   }

   return $linked_path;
} /* eof linkpath() */

/*
 * Generate a list of files in a friendly way by showing the
 * images preview (see the MOD_SHOWFILES_IMGEXTS option) and
 * using a nice user interface. If a specific file is not
 * readable it's not linked and, if it's an image, no preview
 * is shown. For more details look at the code :-)
*/
function showfiles_lsimage($list, $id, $curpath)
{
   $f = 0;
   $text = "<table style='".@constant("MOD_SHOWFILES_TBLSTYLE$instpfx")."' border='0'><tr>";

   // Loop the directories
   foreach($list as $file) {
   
      // Pathname of the current file
      $cp_file = "$curpath/$file";

      // The file is readable
      if( is_readable($cp_file) ) {

	 // Check the file extension for images in order to show a preview
         if( ($ridx = strrpos($file, '.')) && istoggled(MOD_SHOWFILES_IMGEXTS, substr($file, $ridx + 1)) ) {
	    $icon = $cp_file;
	 }
	 else {
            // Select the icon
            $icon = (is_dir($cp_file) ? MOD_SHOWFILES_ICON_DIR : (is_link($cp_file) ?
	       MOD_SHOWFILES_ICON_SYMLINK : MOD_SHOWFILES_ICON_FILE ));

            // If the icon is not on the web then prefix it with the local icons path
            if( ! preg_match("/.+:\/\//", $icon) )
	       $icon = MOD_SHOWFILES_ICONSDIR.$icon;
         }

	 // Generate the URL for the link
	 $link = ( MOD_SHOWFILES_LINK ?
                   "<a href='".(is_dir($cp_file) ?
                   "?modname=showfiles&amp;id=$id&amp;path=$cp_file" :
                   WEBROOT.$cp_file)."'>" :
		   "");

      }
      else {
         // The file is unreadable
	 $icon = MOD_SHOWFILES_ICONSDIR.@constant("MOD_SHOWFILES_ICON_UNREADABLE$instpfx");
	 $link = ""; // Do not link the file
      }

      // Collects all the informations and generate the table
      $text .= "
         <td style='".@constant("MOD_SHOWFILES_OBJSTYLE$instpfx")."'>".($link ? $link : "")."<img
	    src='$icon' alt='$file' style='".@constant("MOD_SHOWFILES_IMGSTYLE$instpfx")."' /></a>
	    <br />
	    ".$link.substr($file, 0, MOD_SHOWFILES_FILEMAXLEN).($link ? "</a>" : "")."</td>
      ";

      // Go to the next line
      if( MOD_SHOWFILES_COLS && ! (++$f % MOD_SHOWFILES_COLS) && isset($list[$f]) )
         $text .= "</tr><tr>";
   }

   // Close the table
   $text .= "</tr></table><br />";

   return $text;
} /* eof showfiles_lsimage() */

/*
 * Show the list of the current availables directories
*/
function showfiles_list()
{

   // Open the tags
   $page = "
      <div id='mod_showfiles_page' class='chems_module'>
         <div class='chems_module_title'>".@constant("MOD_SHOWFILES_TITLE$instpfx")."</div>
         <div class='chems_module_body'>
	 <br /><br /><br />
         <table style='".@constant("MOD_SHOWFILES_TBLSTYLE$instpfx")."' border='0'><tr>
   ";


   // Generate the links
   for($p = 0; isset($MOD_SHOWFILES_PATHS[$p]) && ($path = $MOD_SHOWFILES_PATHS[$p]); $p++) {

      // Add the current element to the list
      $page .= "
         <td style='".@constant("MOD_SHOWFILES_OBJSTYLE$instpfx")."'>
            <a href='?modname=showfiles&amp;id=$p&amp;path=$path[1]'><img
	       src='".@constant("MOD_SHOWFILES_ICONSDIR.MOD_SHOWFILES_ICON_DIR$instpfx")."'
	       alt='$file' style='".@constant("MOD_SHOWFILES_IMGSTYLE$instpfx")."' />
	    <br />
	    ".substr($path[0], 0, MOD_SHOWFILES_FILEMAXLEN)."</a>
	 </td>
      ";

      // Go to the next line
      if( ! (($p+1) % MOD_SHOWFILES_COLS) )
         $page .= "</tr><tr>";
   }

   // Close all the tags
   $page .= "
         </tr></table>
	 </div>
      </div>
   ";

   return $page;
} /* eof showfiles_list() */

?>
