<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * RSS Feeds module (link only)
*/

/*
 * The CHeMS module get function
*/
function rssfeeds_main()
{
   global $module;

   // Check whetever is a post or a page
   $type = ($module->modname === "posts_mgr" ? "post" : "page");

   // Get the mkfeeds.php path and md5
   $f = PATH_MODULES."rssfeeds/mkfeeds.php";
   $md5 = md5_file($f);

   // Link the feeds.php page
   $rssfeeds = "
      <div id='mod_rssfeeds_main' class='chems_module' style='text-align: ".@constant("MOD_RSSFEEDS_ALIGN$instpfx")."'>
         <div class='chems_module_body'>
	    <a type='application/rss+xml' title='".@constant("MOD_RSSFEEDS_LINKTITLE$instpfx")."'
	       href='?chems_file=$f&amp;chems_file_md5=$md5&amp;type=$type'>".@constant("MOD_RSSFEEDS_LINKNAME$instpfx")."</a>
	 </div>
      </div>
   ";

   return $rssfeeds;
} /* eof rssfeeds_main() */ 

?>
