<?php
/* 
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Feeds generation and visualization page.
*/

/*
 * Generate and returns the feeds
 */
function rssfeeds_mkfeed()
{
	// Store and check the feed type
	if( ! ($type = $_GET['type']) )
		return;

	// Check the modules configuration file
	if( ! file_exists(FILE_MODCONF) )
		return;

	// Include the modules configuration file
	require_once(FILE_MODCONF);

	// This is the last modification time (the same as the %[lastmod_time]
	// format operator but compliant with the RFC 822
	$lastmod = date("r", filemtime(PATH_USER));

	/*
	 * XXX: wrong atom URI in href
	 */

	// Generate the RSS Feed informations
	$text = "<?xml version='1.0' encoding='utf-8'?>
		<rss version='2.0' xmlns:atom='http://www.w3.org/2005/Atom'>
		<channel>
		<atom:link href='".getCurrentURI(-1)."' rel='self' type='application/rss+xml' />

		<title>".MOD_RSSFEEDS_RSSTITLE."</title>
		<link>".getCurrentURI().WEBROOT."</link>
		<description>".MOD_RSSFEEDS_DESCR."</description>
		<lastBuildDate>$lastmod</lastBuildDate>
		<language>en-us</language>
	";

	/*
	 * Select the items list (the CHeMS object).
	 * After selected the item i only have to generate the file name
	 * for the objects and include it in order to associate the $object
	 * variable to the relative list. Then i'll set the type if needed,
	 * and finally (later - below) check and show the RSS items.
	*/
	$name = strtoupper($type);
	$file = @constant("MOD_".$name."SMGR_DB");

	// Ensure the file really exists
	if( ! file_exists($file) )
		return;

	require_once($file); // Include the file
	$object = ${$name}; // Point to the object

	$epost = (MOD_POSTSMGR_POST_MAX ? ($posts > MOD_POSTSMGR_POST_MAX ? $posts - MOD_POSTSMGR_POST_MAX : 0) : 0); 

	// Add the items, if any
	for($p = $posts; $p > $epost; $p--) {
		// Both body and title are needed in order to validate the feed
		if( ! (isset($POST[$p]) && ($obj = $POST[$p]) && $obj["body"] && $obj["title"]) )
			continue;

		// Get the catogories
		$cats = ($obj["categories"] ? $obj["categories"] : "none");

		// String to append to the current URI
		$urlcat = "?modname=".$type."s_mgr&amp;$type=$item";

		$text .= "
			<item>
			<title>".$obj['title']."</title>
			<link>".getCurrentURI().WEBROOT.$urlcat."</link>
			<guid>".getCurrentURI().WEBROOT.$urlcat."</guid>
			<pubDate>".date("r", strtotime($obj['date']))."</pubDate>
			<category>$cats</category>
			<description>".substr(strip_tags($obj['body']), 0, MOD_RSSFEEDS_LEN).
	       (strlen(strip_tags($obj['body'])) > MOD_RSSFEEDS_LEN ?
	          MOD_RSSFEEDS_SUSP : "")."</description>
         </item>
      ";
   }

   // Close the feed channel and RSS
   $text .= "
         </channel>
      </rss>
   ";

   return $text;
} /* eof rssfeeds_mkfeed() */

/*
 * Return the current full URI. If the $full variable is
 * non-zero, then the port and the whole queries list is
 * appended to the URI. If $full is negative all the
 * special characters of the queries string are replaced
 * with the relative HTML entities.
*/
function getCurrentURI($full=0)
{

   // Root of the web site
   $uri = strtolower(substr($_SERVER['SERVER_PROTOCOL'], 0,
                     strpos($_SERVER['SERVER_PROTOCOL'], '/'))).
          "://" . $_SERVER['SERVER_NAME'];

   // Add the port and queries
   if( $full )
      $uri .= ":" . $_SERVER['SERVER_PORT'] .
                    ($full > 0 ? $_SERVER['REQUEST_URI'] :
		     htmlspecialchars($_SERVER['REQUEST_URI']));

   return $uri;
} /* eof getCurrentURI() */

// Generate and show the feed
print rssfeeds_mkfeed();

?>
