<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
*/      

defined("_CEXEC") or die ("Restricted access!");

/*
 * Navigation bar module
*/

/*    
 * Generate the navigation bar
*/
function navbar_main()
{
   global $module;

   // Select the bar text
   switch($module->modname) {
      case "posts_mgr":
         $suffix = "POST";
         if( ! isset($_GET['post']) )
	    $suffix .= "S";
	 break;
      case "pages_mgr":
         $suffix = "PAGE";
	 break;
   }

   // Get the navigation bar text
   $navbar_msg = @constant("MOD_NAVBAR_MSG".$suffix);

   // Empty navbar: do nothing
   if( ! $navbar_msg )
        return;

   // Set the separator position (and div ID for CSS)
   $sep = ($module->side === "top" ? "after" : "before");

   // Get all formats operators and expansions
   getfoexp($FO, $FOEXP);
   
   // Open the module divs
   $nb = "
      <div id='mod_navbar' class='chems_module'>
         <div id='navbar_$sep' class='chems_module_body'>
   ";
    
   // Add the user text after/before an horizontal line (expands the format operators)
   $nb .= ($sep === "before" ? "<hr />" : "").str_replace($FO, $FOEXP, $navbar_msg).($sep === "after" ? "<hr />" : "");
   
   // Close the module divs
   $nb .= "</div></div>"; 

   return $nb;
} /* eof navbar_main() */

/*
 * Get all formats operators and expansions values.
 * This function has been written just to leave the code "clean".
*/
function getfoexp(&$FO, &$FOEXP)
{
   global $module;

   require(MOD_POSTSMGR_DB);
   require(MOD_PAGESMGR_DB);

   /*
    * Handle navigation bar for the posts_mgr module
   */
   if( $module->modname === "posts_mgr" ) {

      /* Single post */
      if( isset($_GET['post']) ) {
         $page_current = ($_GET['post'] ? $_GET['post'] : 1);
         $pages_total = $posts;
      }

      /* Posts list */
      else {

	// Calculate the number of navigation pages
	if( ! MOD_POSTSMGR_POSTSPERPAGE )
		return;

	if( MOD_POSTSMGR_POSTSPERPAGE < 0 || $posts <= MOD_POSTSMGR_POSTSPERPAGE )
		$pages_total = 1;
	else {
		$pages_total = (int)($posts / MOD_POSTSMGR_POSTSPERPAGE);
		if( $posts % MOD_POSTSMGR_POSTSPERPAGE )
			++$pages_total;
	}

	$list_id = (isset($_GET['list']) ? $_GET['list'] : 1);
	$page_current = ($list_id < 1 || $list_id > $pages_total ? 1 : $list_id);

      }
   }

   /*
    * Handle navigation bar for the pages_mgr module
   */
   else {
      /* Single page */
      $page_current = (isset($_GET['page']) ? $_GET['page'] : 1);
      $pages_total = $pages;
   }

   // Get posts extremes
   xtrset($posts, MOD_POSTSMGR_POSTSPERPAGE, $inf, $sup, MOD_POSTSMGR_LIST_SORT);

   // Formats operators
   $FO = array(
      "%[elem_curr]",

      /*
       * Posts
      */
      "%[post_prev]",         // Previous post
      "%[post_next]",         // Next post
      "%[posts_total_link]",  // As %[posts_total] but links if it's not the current post
      "%[post_inf]",          // The post with highest ID in the current list
      "%[post_sup]",          // The post with lowest ID in the current list

      /*
       * Pages
      */
      "%[page_prev]",         // Previous page
      "%[page_next]",         // Next page
      "%[pages_total]",       // Total pages
      "%[pages_total_link]",  // As %[pages_total] but links if it's not the current page
   );

   // Formats operators expansions
   $FOEXP = array(
      $page_current,

      // %[post_prev]
      ($page_current - 1 ? $page_current - 1 : $posts),

      // %[post_next]
      ($page_current == $posts ? 1 : $page_current + 1),

      // %[posts_total_link]
      ($page_current == $posts ? $posts : "<a href='?modname=posts_mgr&amp;post=$posts'>$posts</a>"),

      // %[post_inf]
      $inf,

      // %[post_sup]
      $sup,

      /*
       * Pages
      */

      // %[page_prev]
      ($page_current - 1 > 0 ? $page_current - 1 : $pages_total),

      // %[page_next]
      ($page_current == $pages_total ? 1 : $page_current + 1),

      // %[pages_total]
      $pages_total,

      // %[pages_total_link]
      ($page_current == $pages_total ? $pages_total :
         "<a href='?modname=pages_mgr&amp;page=$pages_total'>$pages_total</a>"),
   );
   
} /* eof getfoexp() */

?>
