<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Contacts module
*/

/*
 * The CHeMS module get function
*/
function contacts_page()
{
   // Generate the instance postfix
   $instpfx = (isset($module->istance) && $module->instance ? $instpfx = "_".strtoupper($module->instance) : '');

   global ${"MOD_CONTACTS_NAMES".$instpfx};

   if( isset($_GET['do']) ) {
      
      if( $_GET['do'] === "send" ) {

	 // Cannot send mails without a recipient
	 if( ! isset($_POST['modcontacts_recipient']) )
	    return MOD_CONTACTS_ERROR;

         $name = (isset($_POST['modcontacts_name']) && $_POST['modcontacts_name'] !== "" ?
            $_POST['modcontacts_name'] : MOD_CONTACTS_NOFIELD_NAME);
         $email = (isset($_POST['modcontacts_email']) && $_POST['modcontacts_email'] !== "" ?
            $_POST['modcontacts_email'] : MOD_CONTACTS_NOFIELD_MAIL);
         $body = (isset($_POST['modcontacts_body']) && $_POST['modcontacts_body'] !== "" ?
            $_POST['modcontacts_body'] : MOD_CONTACTS_NOFIELD_BODY);
         $subject = MOD_CONTACTS_PRESUBJ .
            (isset($_POST['modcontacts_subject']) && $_POST['modcontacts_subject'] !== "" ?
               $_POST['modcontacts_subject'] : MOD_CONTACTS_NOFIELD_SUBJ);

	 $recipient = $_POST['modcontacts_recipient'];
	 $header = "From: ". $name . " <" . $email . ">\r\n";

         // Send the mail
	 if( mail($recipient, $subject, $body, $header) ) {
            $end_body = MOD_CONTACTS_FINISH;

	    // Send a copy to $email
	    if( (isset($_POST['modcontacts_copy']) && $_POST['modcontacts_copy'] === "send" ? true : false) )
	       mail($email, $subject, $body, $header); // Ignore errors
	 }
	 else
            $end_body = MOD_CONTACTS_ERROR;
      }
      else
         $end_body = MOD_CONTACTS_WRONG;

      return "
         <div id='mod_contacts".$instpfx."_main' class='chems_module'>
            <div class='chems_module_title'>".@constant("MOD_CONTACTS_TITLE$instpfx")."</div>
            <div class='chems_module_body'>$end_body</div>
         </div>
      ";
   }

   // Get the contacts
   $contacts = ${"MOD_CONTACTS_NAMES".$instpfx};
   $addrs = sizeof($contacts);
   $selid = isset($_GET['selid']) ? $_GET['selid'] : 0;

   // Empty list (no names e/o addresses) generates an error
   if( ! $addrs )
      return CHEMS_MODULE_FAILURE;
   
   // Open the tags
   $page = "
      <div class='chems_module'>
         <div class='chems_module_title'>".@constant("MOD_CONTACTS_TITLE$instpfx")."</div>
         <div class='chems_module_body'>

	 ".@constant("MOD_CONTACTS_PREFORM$instpfx")."

         <form action='?modname=contacts&amp;do=send' method='post'>

            <fieldset>
               <legend><b>".@constant("MOD_CONTACTS_FORM_TITLE$instpfx")."</b></legend>
	       <br />

   ";
   
   // Load the contacts names and addresses into the form
   $page .= MOD_CONTACTS_FIELDPEOPLE."<br /><select name='modcontacts_recipient'>";
   for($a = 0; isset($contacts[$a]) && ($addr = $contacts[$a]); $a++)
   {
      /*
       * 0 Name
       * 1 Address
      */

      // Ignore "wrong" contacts
      if($addr[0] && $addr[1]) {
	 $page .= "
	    <option value='$addr[1]'" . ($a == $selid ? " selected='selected'>" : '>') . "
	       $addr[0]
	    </option>
	 ";
      }

   }
   $page .= "</select><br /><br />";

   $page .= "
               <label for='modcontacts_name'>".@constant("MOD_CONTACTS_FIELDNAME$instpfx")."</label><br />
               <input type='text' name='modcontacts_name' id='modcontacts_name' /><br />

               <label for='modcontacts_email'>".@constant("MOD_CONTACTS_FIELDEMAIL$instpfx")."</label><br />
               <input type='text' name='modcontacts_email' id='modcontacts_email' /><br />

               <label for='modcontacts_subject'>".@constant("MOD_CONTACTS_FIELDSUBJ$instpfx")."</label><br />
               <input type='text' name='modcontacts_subject' id='modcontacts_subject' /><br />

               <label for='modcontacts_body'>".@constant("MOD_CONTACTS_FIELDBODY$instpfx")."</label><br />
               <textarea name='modcontacts_body' id='modcontacts_body' rows='5' cols='50' /></textarea><br />

               <input type='checkbox' name='modcontacts_copy' id='modcontacts_copy' value='send' />
               <label for='modcontacts_copy'>".@constant("MOD_CONTACTS_FIELDCOPY$instpfx")."</label><br />
	       <br />

	       <!-- Submit fields -->
               <input type='submit' name='modcontacts_submit' id='modcontacts_submit' value='".@constant("MOD_CONTACTS_SUBMIT$instpfx")."' />
               <input type='reset' name='modcontacts_clear' id='modcontacts_clear' value='".@constant("MOD_CONTACTS_RESET$instpfx")."' />

            </fieldset>
         </form>

         ".@constant("MOD_CONTACTS_POSTFORM$instpfx")."

         </div>
      </div>
   ";

   return $page;
} /* eof contacts_main() */

?>
