<?php
/*
 * CHeMS (Content HElper Management System)
 * Copyright (C) 2007-2009  Claudio M. Alessi
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
*/

defined("_CEXEC") or die ("Restricted access!");

/*
 * Comments module
*/

// Include the TFB DB API routines
require_once(PATH_SOURCES."cdb.php");

/*
 * The CHeMS module get function
*/
function comments_main() {
   global $module;

   // No multiple instances are allowed for this module
   if( $module->instid )
      return CHEMS_MODULE_FAILURE;

   // Check if it's a valid module
   if( $module->modname === "posts_mgr" )
      $type = "post";
   else if( $module->modname === "pages_mgr" )
      $type = "page";
   else
      return CHEMS_MODULE_FAILURE; // Error
   
   // Get the ID for the current module object (don't show in posts list)
   if( ! isset($_GET[$type]) || ! ($id = $_GET[$type]) )
      return; // No error reported

   // Check the "show" and "unshow" options
   if( isset($module->show) && isset($module->unshow) && (! istoggled($module->show, $id) || istoggled($module->unshow, $id)) )
      return ;

   $db = @constant("MOD_".strtoupper($type)."SMGR_DB");
   $obj = isset(${strtoupper($type)}[$id]) ? ${strtoupper($type)}[$id] : '';

   // Check if the current object exists
   if( ! ((require($db)) || $obj) )
      return CHEMS_MODULE_FAILURE;

   // Generate the form action
   $action = "?modname=".$module->modname."&amp;$type=$id";

   $match['id'] = $id;
   $match['modname'] = $module->modname;

   $comments = " 
      <div id='mod_comments_main' class='chems_module'>
         <div class='chems_module_body'>
	 <br />
   ";

   // The comment has been sent, validate and, if it's okay, save it
   if ( isset($_POST['modcom_body']) ) {
      
      // Check if anti-spam check is enabled. If yes, check the validation code
      if( ! MOD_COMMENTS_FIELD_ANTISPAM || ($_POST['modcom_hidden_code'] && $_POST['modcom_code'] === $_POST['modcom_hidden_code']) ) {

         // Insert the "http://" suffix, if none
	 if( ! preg_match("/.+:\/\//", $_POST['modcom_page']) )
	    $_POST['modcom_page'] = "http://" . $_POST['modcom_page'];

         //
	 // Create the comment record
	 //
	 $comment['author'] 	= $_POST['modcom_name'];
	 $comment['page'] 	= $_POST['modcom_page'];
	 $comment['email'] 	= $_POST['modcom_email'];
	 $comment['body'] 	= $_POST['modcom_body']; // Always exists

	 // Set the element ID and type
	 $comment['id'] = $match['id'];
	 $comment['name'] = (isset($match["name"]) ? $match["name"] : MOD_CONTACTS_NOFIELD_NAME);

	 // Differentiate modules where comments are allowed
	 $comment['module'] = $module->modname;

	 // Store the record (hopeful)
         if( CommentInsert($comment) )
	   $comments .= MOD_COMMENTS_MSG_INSOK;
	 else
	   $comments .= MOD_COMMENTS_MSG_INSKO;

      }
      else
	 $comments .= MOD_COMMENTS_MSG_WRONGSPAMCODE;
   }


   // Get the comments list
   $comments .= CommentList($match);

   $randstr = getRandString(MOD_COMMENTS_CODE_LEN);
   $comments .= "<br /><br />

      ".MOD_COMMENTS_PREFORM."
      <form action='".$action."' method='post'>

         <fieldset>
            <legend><b>".@constant("MOD_COMMENTS_MSG_TITLE$instpfx")."</b></legend>
	    <br />

            <label for='modcom_name'>".@constant("MOD_COMMENTS_MSG_FIELDNAME$instpfx")."</label><br />
            <input type='text' name='modcom_name' id='modcom_name' /><br />

            <label for='modcom_page'>".@constant("MOD_COMMENTS_MSG_FIELDPAGE$instpfx")."</label><br />
            <input type='text' name='modcom_page' id='modcom_page' /><br />

            <label for='modcom_email'>".@constant("MOD_COMMENTS_MSG_FIELDMAIL$instpfx")."</label><br />
            <input type='text' name='modcom_email' id='modcom_email' /><br />

            <label for='modcom_body'>".@constant("MOD_COMMENTS_MSG_FIELDBODY$instpfx")."</label><br />
            <textarea name='modcom_body' id='modcom_body' rows='5' cols='50'></textarea><br />

	    ". (MOD_COMMENTS_FIELD_ANTISPAM ? "

            <label for='modcom_code'>".@constant("MOD_COMMENTS_MSG_FIELDCODE$instpfx")."<b>$randstr</b></label><br />
            <input type='text' name='modcom_code' id='modcom_code' /><br />
            <input type='hidden' name='modcom_hidden_code' id='modcom_hidden_code' 
	           value='".$randstr."' /><br />
            " : "") ."

	    <!-- Submit fields -->
            <input type='submit' name='modcom_submit' id='modcom_submit' value='".@constant("MOD_COMMENTS_MSG_SUBMIT$instpfx")."' />
            <input type='reset' name='modcom_clear' id='modcom_clear' value='".@constant("MOD_COMMENTS_MSG_RESET$instpfx")."' />

         </fieldset>

      </form>
      ".MOD_COMMENTS_POSTFORM."
   ";

   $comments .= "
	 </div>
      </div>
   ";

   // Return the whole module
   return $comments;
} /* eof comments_main() */

/*
 * Insert the comment into the comments list
*/
function CommentInsert($comm)
{
   return (cdb_insert(MOD_COMMENTS_DBFILE, fixcode($comm)) == -1 ? False : True);
} /* eof CommentInsert() */

/*
 * Return all "selected" comments
*/
function CommentList($match)
{
   // Total comments
   $comm_tot = cdb_totals(MOD_COMMENTS_DBFILE, $match, $list);

   // Open the comments div
   $comm_list = "<div class='comm_comments'>";

   if( $comm_tot )
      $comm_list .= MOD_COMMENTS_MSG_TOTAL;
   else
      $comm_list .= MOD_COMMENTS_MSG_NONE;

   // Dynamic format operators (see replacements below)
   $FOLIST = array(
      "%[name]",
      "%[page]",
      "%[email]",
      "%[body]",
      "%[dyname]"
   );

   // Create the comments list
   for($id = sizeof($list) - 1; $id >= 0; $id--) {


      // Get the record
      if( !($comm = cdb_return(MOD_COMMENTS_DBFILE, $list[$id], $match)) )
         continue;

      // Get the linked/unliked/unknown author
      $dyname = "<div class='comm_author'>";
      $author = isset($comm["author"]) ? $comm["author"] : '';
      $author_name = ($author ? "<b>$author</b>" : '');
      if( $comm['page'] && $author )
	 $dyname .= "<a href='".$comm['page']."'>$author_name</a>";
      else if( $author )
	 $dyname .= "$author_name";
      else
	 $dyname .= "<b>".@constant("MOD_COMMENTS_UKN_AUTHORNAME$instpfx")."</b>";
      $dyname .= "</div>";

      //
      // Replacements for the dynamic format operators
      //
      $FOREPS = array(
         (isset($comm['author']) ? "<div class='comm_author'>".$comm['author']."</div>" :
	                    MOD_COMMENTS_UKN_AUTHORNAME),
	 (isset($comm['page']) ? "<div class='comm_page'>".$comm['page']."</div>" :
	                    MOD_COMMENTS_UKN_AUTHORPAGE),
	 (isset($comm['email']) ? "<div class='comm_email'>".$comm['email']."</div>" :
	                    MOD_COMMENTS_UKN_AUTHOREMAIL),
	 "<div class='comm_body'>".(isset($comm['body']) ? $comm["body"] : '')."</div>",
	 $dyname,
      );

                    // Dynamic format operators
      $comm_list .= str_replace($FOLIST, $FOREPS, MOD_COMMENTS_COMM_BOX);
   }

   $comm_list .= "</div>";

          // Non dynamic format operators
   return str_replace("%[totals]", $comm_tot, $comm_list);
} /* eof CommentList() */

/*
 * Get a random string $len characters length
*/
function getRandString($slen)
{

   // Characters to use randomly
   $charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
   $str = '';

   // Put the $slen characters into the string
   while($slen) {
      $str .= $charset[ rand(0, strlen($charset) - 1) ];
      --$slen;
   }

   return $str;
} /* eof getRandString() */

/*
 * Remove all HTML tags and replace all "problematic" characters with
 * the corresponding HTML codes. Finally return the new array.
*/
function fixcode($comm)
{
   // Fix the values for all array keys
   foreach($comm as $key => $value) {
      $comm[$key] = strip_tags($value);
      $comm[$key] = nl2br(htmlspecialchars($comm[$key], ENT_QUOTES));
   }

   return $comm;
} /* eof fixcode() */

?>
