/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charvax.swing.table.TableHeader;

public class JViewport
extends Container {
    private Component _child;
    private Dimension _extent;

    public void setView(Component child_) {
        if (!(child_ instanceof Scrollable) && !(child_ instanceof TableHeader)) {
            throw new IllegalArgumentException("JViewport's view must be a Scrollable or a TableHeader");
        }
        if (this._child != null) {
            super.remove(this._child);
        }
        super.add(child_);
        this._child = child_;
    }

    public Component getView() {
        return this._child;
    }

    public void draw() {
        Toolkit term = Toolkit.getDefaultToolkit();
        Point origin = this.getLocationOnScreen();
        term.setClipRect(new Rectangle(origin, this.getExtentSize()));
        this._child.draw();
        term.resetClipRect();
    }

    public Point getViewPosition() {
        return this._child.getLocation();
    }

    public void setViewPosition(Point origin_) {
        this._child.setLocation(origin_);
    }

    public Dimension getViewSize() {
        return this._child.getSize();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.getLocation(), this.getExtentSize());
    }

    void setExtentSize(int width, int height) {
        this._extent = new Dimension(width, height);
    }

    public Dimension getExtentSize() {
        return new Dimension(this._extent);
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("Viewport origin=" + this._origin + " size=" + this.getSize());
        super.debug(level_ + 1);
    }
}

