/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Dimension;
import charva.awt.Font;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.ActionEvent;
import charva.awt.event.ActionListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charvax.swing.text.JTextComponent;
import java.util.Enumeration;
import java.util.Vector;

public class JTextField
extends JTextComponent {
    protected boolean _bold = false;
    protected int _columns;
    protected int _offset = 0;
    protected String _padding;
    private String _actionCommand = new String("");
    protected Vector _actionListeners = null;

    public JTextField() {
        this("", 10);
    }

    public JTextField(String text_) {
        this(text_, text_.length());
    }

    public JTextField(int length_) {
        this("", length_);
    }

    public JTextField(String text_, int length_) {
        super.setText(text_);
        this.setColumns(length_);
        this._caretPosition = this._document.length();
        this._offset = this._document.length() > this._columns ? this._document.length() - this._columns : 0;
    }

    public void setColumns(int columns_) {
        this._columns = columns_;
        StringBuffer padbuf = new StringBuffer();
        for (int i = 0; i < this._columns; ++i) {
            padbuf.append(' ');
        }
        this._padding = new String(padbuf);
        super.invalidate();
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.setColumns(bounds.getRight() - bounds.getLeft() + 1);
    }

    public void setBounds(int top_, int left_, int bottom_, int right_) {
        super.setBounds(top_, left_, bottom_, right_);
        this.setColumns(right_ - left_ + 1);
    }

    public void setBounds(Point topleft_, Dimension size_) {
        super.setBounds(topleft_, size_);
        this.setColumns(size_.width);
    }

    public int getColumns() {
        return this._columns;
    }

    public void setFont(Font font_) {
        this._bold = (font_.getStyle() & 1) != 0;
    }

    public void setActionCommand(String cmd_) {
        this._actionCommand = cmd_;
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public Dimension getSize() {
        Insets insets = super.getInsets();
        return new Dimension(this._columns + insets.left + insets.right, 1 + insets.top + insets.bottom);
    }

    public int getWidth() {
        Insets insets = super.getInsets();
        return this._columns + insets.left + insets.right;
    }

    public int getHeight() {
        Insets insets = super.getInsets();
        return 1 + insets.top + insets.bottom;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void setEditable(boolean editable_) {
        super.setEnabled(editable_);
    }

    public boolean isEditable() {
        return this.isEnabled();
    }

    public void draw() {
        super.draw();
        int attrib = 0;
        if (this._enabled) {
            attrib |= Toolkit.A_UNDERLINE;
        }
        if (this._bold) {
            attrib |= Toolkit.A_BOLD;
        }
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        term.setCursor(origin);
        term.addString(this._padding, attrib, colorpair);
        term.setCursor(origin);
        int end = super.getText().length() > this._offset + this._columns ? this._offset + this._columns : super.getText().length();
        term.addString(super.getText().substring(this._offset, end).toString(), attrib, colorpair);
        term.setCursor(origin.addOffset(this._caretPosition - this._offset, 0));
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        int key = ke_.getKeyCode();
        if (key == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (key == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (!ke_.isActionKey()) {
            if (key >= 32) {
                this._document.insert(this._caretPosition, (char)key);
                ++this._caretPosition;
                if (this._caretPosition - this._offset > this._columns) {
                    ++this._offset;
                }
            }
        } else if (key == 260 && this._caretPosition > 0) {
            --this._caretPosition;
            if (this._caretPosition < this._offset) {
                --this._offset;
            }
        } else if (key == 261 && this._caretPosition < this._document.length()) {
            ++this._caretPosition;
            if (this._caretPosition - this._offset > this._columns) {
                ++this._offset;
            }
        } else if (key == 263 && this._caretPosition > 0) {
            --this._caretPosition;
            this._document.deleteCharAt(this._caretPosition);
            if (this._caretPosition < this._offset) {
                --this._offset;
            }
        } else if (key == 330 && this._caretPosition >= 0 && this._caretPosition < this._document.length()) {
            this._document.deleteCharAt(this._caretPosition);
        } else if (key == 262) {
            this._caretPosition = 0;
            this._offset = 0;
        } else if (key == 360) {
            this._caretPosition = this._document.length();
            this._offset = this._document.length() > this._columns ? this._document.length() - this._columns : 0;
        } else if (key == 343) {
            ActionEvent ae = new ActionEvent(this, this._actionCommand);
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(ae);
        }
        this.draw();
        super.requestSync();
    }

    public void processMouseEvent(MouseEvent e_) {
        super.processMouseEvent(e_);
        if (e_.getButton() == 1 && e_.getModifiers() == 102 && this.isFocusTraversable()) {
            int x = e_.getX();
            Point origin = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            origin.translate(insets.left, insets.top);
            int new_caret = this._offset + (x - origin.x);
            this._caretPosition = new_caret < this._document.length() ? new_caret : this._document.length();
            this.repaint();
        }
    }

    public synchronized void setText(String text_) {
        super.setText(text_);
        this._caretPosition = this._document.length();
        this._offset = this._document.length() > this._columns ? this._document.length() - this._columns : 0;
        super.repaint();
    }

    protected void processEvent(AWTEvent evt_) {
        super.processEvent(evt_);
        if (evt_ instanceof ActionEvent) {
            this.postActionEvent((ActionEvent)evt_);
        }
    }

    public void postActionEvent(ActionEvent ae_) {
        if (this._actionListeners != null) {
            Enumeration e = this._actionListeners.elements();
            while (e.hasMoreElements()) {
                ActionListener al = (ActionListener)e.nextElement();
                al.actionPerformed(ae_);
            }
        }
    }

    public void addActionListener(ActionListener al_) {
        if (this._actionListeners == null) {
            this._actionListeners = new Vector();
        }
        this._actionListeners.add(al_);
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        Insets insets = super.getInsets();
        origin.translate(insets.left, insets.top);
        Toolkit.getDefaultToolkit().setCursor(origin.addOffset(this._caretPosition - this._offset, 0));
    }

    public String toString() {
        return "JTextField location=" + this.getLocation() + " text=\"" + this._document + "\"" + " actionCommand=\"" + this._actionCommand + "\"";
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JTextField origin=" + this._origin + " size=" + this.getSize() + " text=" + this._document);
    }
}

