/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Scrollable;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charva.awt.event.MouseEvent;
import charva.awt.event.ScrollEvent;
import charva.awt.event.ScrollListener;
import charvax.swing.JViewport;
import charvax.swing.text.JTextComponent;
import java.util.Enumeration;
import java.util.Vector;

public class JTextArea
extends JTextComponent
implements Scrollable {
    private int _rows;
    private int _columns;
    private int _preferredRows;
    private int _preferredColumns;
    private Point _caret = new Point(0, 0);
    private boolean _lineWrap;
    private boolean _wrapStyleWord = false;
    private Vector _scrollListeners = null;
    private static final int LINE_COUNT = 1;
    private static final int LINE_START_OFFSET = 2;
    private static final int LINE_END_OFFSET = 3;
    private static final int LINE_OF_OFFSET = 4;

    public JTextArea() {
        this("");
    }

    public JTextArea(String text_) {
        this(text_, 10, 10);
    }

    public JTextArea(String text_, int rows_, int columns_) {
        this.setDocument(text_);
        this._rows = rows_;
        this._preferredRows = rows_;
        this._columns = columns_;
        this._preferredColumns = columns_;
        this.setCaretPosition(0);
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
        this.setColumns(bounds.getRight() - bounds.getLeft() + 1);
        this.setRows(bounds.getBottom() - bounds.getTop() + 1);
    }

    public void setBounds(int top_, int left_, int bottom_, int right_) {
        super.setBounds(top_, left_, bottom_, right_);
        this.setColumns(right_ - left_ + 1);
        this.setRows(bottom_ - top_ + 1);
    }

    public void setBounds(Point topleft_, Dimension size_) {
        super.setBounds(topleft_, size_);
        this.setColumns(size_.width);
        this.setRows(size_.height);
    }

    public void setColumns(int columns_) {
        this._columns = columns_;
        this._preferredColumns = columns_;
    }

    public int getColumns() {
        return this._preferredColumns;
    }

    public void setRows(int rows_) {
        this._rows = rows_;
        this._preferredRows = rows_;
    }

    public int getRows() {
        return this._preferredRows;
    }

    public Dimension getSize() {
        return new Dimension(this._columns, this._rows);
    }

    public int getWidth() {
        return this._columns;
    }

    public int getHeight() {
        return this._rows;
    }

    public synchronized void append(String text_) {
        this._document.append(text_);
        this._caretPosition = this._document.length();
        this.refresh();
    }

    public synchronized void insert(String text_, int pos_) {
        this._document.insert(pos_, text_);
        this._caretPosition = pos_ + text_.length();
        this.refresh();
    }

    public synchronized void replaceRange(String text_, int start_, int end_) {
        this._document.replace(start_, end_, text_);
        this._caretPosition = start_ + text_.length();
        this.refresh();
    }

    public void setCaretPosition(int caret_) {
        super.setCaretPosition(caret_);
        this.refresh();
    }

    public int getLineCount() {
        return this.offsetCalc(1, 0);
    }

    public int getLineStartOffset(int line_) {
        return this.offsetCalc(2, line_);
    }

    public int getLineEndOffset(int line_) {
        return this.offsetCalc(3, line_);
    }

    public int getLineOfOffset(int offset_) {
        return this.offsetCalc(4, offset_);
    }

    public void setLineWrap(boolean wrap_) {
        this._lineWrap = wrap_;
        this._rows = this._preferredRows;
        this._columns = this._preferredColumns;
    }

    public boolean getLineWrap() {
        return this._lineWrap;
    }

    public void setWrapStyleWord(boolean wrapWord_) {
        this._wrapStyleWord = wrapWord_;
    }

    public boolean getWrapStyleWord() {
        return this._wrapStyleWord;
    }

    public Dimension minimumSize() {
        return this.getSize();
    }

    public void processKeyEvent(KeyEvent ke_) {
        super.processKeyEvent(ke_);
        if (ke_.isConsumed()) {
            return;
        }
        int caret = this.getCaretPosition();
        int line = this.getLineOfOffset(caret);
        int key = ke_.getKeyCode();
        if (key == 9) {
            this.getParent().nextFocus();
            return;
        }
        if (key == 353) {
            this.getParent().previousFocus();
            return;
        }
        if (key == 260 && caret > 0) {
            this.setCaretPosition(caret - 1);
        } else if (key == 261 && caret < this.getDocument().length()) {
            this.setCaretPosition(caret + 1);
        } else if (key == 262) {
            int lineStart = this.getLineStartOffset(line);
            this.setCaretPosition(lineStart);
        } else if (key == 360) {
            int lineEnd = this.getLineEndOffset(line);
            this.setCaretPosition(lineEnd);
        } else if ((key == 339 || key == 338) && this.getParent() instanceof JViewport) {
            JViewport viewport = (JViewport)this.getParent();
            int vertical_offset = -1 * viewport.getViewPosition().y;
            int viewport_height = viewport.getSize().height;
            if (key == 339) {
                line = line > vertical_offset ? vertical_offset : vertical_offset - viewport_height;
                line = line < 0 ? 0 : line;
            } else {
                line = line < vertical_offset + viewport_height - 1 ? vertical_offset + viewport_height - 1 : vertical_offset + 2 * viewport_height - 1;
                line = line > this.getLineCount() - 1 ? this.getLineCount() - 1 : line;
            }
            this.setCaretPosition(this.getLineStartOffset(line));
        } else if (key == 259 && line > 0) {
            int column = caret - this.getLineStartOffset(line);
            int prevlineStart = this.getLineStartOffset(line - 1);
            int prevlineEnd = this.getLineEndOffset(line - 1);
            if (column > prevlineEnd - prevlineStart) {
                column = prevlineEnd - prevlineStart;
            }
            this.setCaretPosition(prevlineStart + column);
        } else if (key == 258 && line < this.getLineCount() - 1) {
            int column = caret - this.getLineStartOffset(line);
            int nextlineStart = this.getLineStartOffset(line + 1);
            int nextlineEnd = this.getLineEndOffset(line + 1);
            if (column > nextlineEnd - nextlineStart) {
                column = nextlineEnd - nextlineStart;
            }
            this.setCaretPosition(nextlineStart + column);
        } else if (!super.isEditable()) {
            Toolkit.getDefaultToolkit().beep();
        } else if (key >= 32 && key <= 127) {
            char[] arry = new char[]{(char)key};
            this.insert(new String(arry), caret);
        } else if (key == 343) {
            char[] arry = new char[]{'\n'};
            this.insert(new String(arry), caret);
        } else if (key == 263 && caret > 0) {
            this.replaceRange("", caret - 1, caret);
        } else if (key == 330 && caret < this.getDocument().length() - 1) {
            this.replaceRange("", caret, caret + 1);
        }
        if (!(this.getParent() instanceof JViewport)) {
            this.draw();
            this.requestFocus();
            super.requestSync();
        }
    }

    public void processMouseEvent(MouseEvent e_) {
        super.processMouseEvent(e_);
        if (e_.getButton() == 1 && e_.getModifiers() == 102 && this.isFocusTraversable()) {
            Point origin = this.getLocationOnScreen();
            Insets insets = super.getInsets();
            origin.translate(insets.left, insets.top);
            int line = e_.getY() - origin.y;
            if (line > this.getLineCount() - 1) {
                return;
            }
            int column = e_.getX() - origin.x;
            int lineStart = this.getLineStartOffset(line);
            int lineEnd = this.getLineEndOffset(line);
            if (column > lineEnd - lineStart) {
                column = lineEnd - lineStart;
            }
            this.setCaretPosition(lineStart + column);
            this.repaint();
        }
    }

    public void draw() {
        Point tempCaret = null;
        Point caret = this._caret;
        Point origin = this.getLocationOnScreen();
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        term.blankBox(origin, this.getSize(), colorpair);
        term.setCursor(origin);
        ScrollEvent scrollevent = null;
        int row = 0;
        int col = 0;
        for (int i = 0; i < this._document.length(); ++i) {
            int j;
            if (this._caretPosition == i && !(tempCaret = new Point(col, row)).equals(caret)) {
                scrollevent = this.generateScrollEvent(tempCaret, new Point(col, row));
                caret = tempCaret;
            }
            char chr = this._document.charAt(i);
            if (col < this._columns) {
                if (chr == '\n') {
                    col = 0;
                    if (++row >= this._rows) {
                        ++this._rows;
                    }
                    term.setCursor(origin.addOffset(col, row));
                    continue;
                }
                term.addChar(chr, 0, colorpair);
                ++col;
                continue;
            }
            if (!this._lineWrap) {
                if (chr == '\n') {
                    col = 0;
                    if (++row >= this._rows) {
                        ++this._rows;
                    }
                    term.setCursor(origin.addOffset(col, row));
                    continue;
                }
                term.addChar(chr, 0, colorpair);
                ++col;
                ++this._columns;
                continue;
            }
            if (!this._wrapStyleWord) {
                col = 0;
                if (++row >= this._rows) {
                    ++this._rows;
                }
                term.setCursor(origin.addOffset(col, row));
                if (chr == '\n') continue;
                term.addChar(chr, 0, colorpair);
                continue;
            }
            for (j = 0; j < this._columns; ++j) {
                char tmpchr = this._document.charAt(i - j);
                if (tmpchr != ' ' && tmpchr != '\t') continue;
                this.deleteEOL(term, col - j, row, colorpair);
                col = 0;
                if (++row >= this._rows) {
                    ++this._rows;
                }
                i -= j;
                term.setCursor(origin.addOffset(col, row));
                break;
            }
            if (j != this._columns || chr != ' ' && chr != '\n' && chr != '\t') continue;
            col = 0;
            if (++row >= this._rows) {
                ++this._rows;
            }
            term.setCursor(origin.addOffset(col, row));
        }
        if (this._caretPosition == this._document.length()) {
            tempCaret = new Point(col, row);
            if (!tempCaret.equals(caret)) {
                scrollevent = this.generateScrollEvent(tempCaret, new Point(col, row));
            }
            caret = tempCaret;
        }
        if (!this._caret.equals(caret) && scrollevent != null) {
            term.getSystemEventQueue().postEvent(scrollevent);
            this._caret = caret;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        Point origin = this.getLocationOnScreen();
        Toolkit.getDefaultToolkit().setCursor(origin.addOffset(this._caret));
    }

    public void addScrollListener(ScrollListener sl_) {
        if (this._scrollListeners == null) {
            this._scrollListeners = new Vector();
        }
        this._scrollListeners.add(sl_);
    }

    public void removeScrollListener(ScrollListener sl_) {
        if (this._scrollListeners == null) {
            return;
        }
        this._scrollListeners.remove(sl_);
    }

    public void processScrollEvent(ScrollEvent e_) {
        if (this._scrollListeners != null) {
            Enumeration e = this._scrollListeners.elements();
            while (e.hasMoreElements()) {
                ScrollListener sl = (ScrollListener)e.nextElement();
                sl.scroll(e_);
            }
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this._preferredColumns, this._preferredRows);
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println("JTextArea origin=" + this._origin + " size=" + this.getSize());
    }

    private void deleteEOL(Toolkit term_, int col_, int row_, int colorpair_) {
        Point origin = this.getLocationOnScreen();
        term_.setCursor(origin.addOffset(col_, row_));
        for (int i = col_; i < this._columns; ++i) {
            term_.addChar(32, 0, colorpair_);
        }
    }

    private int offsetCalc(int mode_, int value_) {
        int lineOfOffset = 0;
        int row = 0;
        if (mode_ == 2 && value_ == 0) {
            return 0;
        }
        int col = 0;
        for (int i = 0; i < this._document.length(); ++i) {
            if (mode_ == 4 && value_ == i) {
                lineOfOffset = row;
            }
            char chr = this._document.charAt(i);
            if (col < this._columns) {
                if (chr == '\n') {
                    col = 0;
                    ++row;
                } else {
                    ++col;
                }
            } else if (!this._lineWrap) {
                if (chr == '\n') {
                    col = 0;
                    ++row;
                }
            } else if (!this._wrapStyleWord) {
                col = 0;
                ++row;
            } else {
                int j;
                for (j = 0; j < this._columns; ++j) {
                    char tmpchr = this._document.charAt(i - j);
                    if (tmpchr != ' ' && tmpchr != '\t') continue;
                    col = 0;
                    ++row;
                    i -= j;
                    break;
                }
                if (j == this._columns && (chr == ' ' || chr == '\n' || chr == '\t')) {
                    col = 0;
                    ++row;
                }
            }
            if (mode_ == 2 && col == 0 && row == value_) {
                return i + 1;
            }
            if (mode_ != 3 || col != 0 || row != value_ + 1) continue;
            return i;
        }
        if (mode_ == 4) {
            if (value_ == this._document.length()) {
                return row;
            }
            return lineOfOffset;
        }
        if (mode_ == 1) {
            return row + 1;
        }
        if (mode_ == 3 && row == value_) {
            return this._document.length();
        }
        throw new IndexOutOfBoundsException("Invalid offset or line number: mode=" + mode_ + " value=" + value_ + " row=" + row + " doc=\"" + this._document + "\"");
    }

    private void refresh() {
        Component todraw = this.getParent() instanceof JViewport ? this.getParent() : this;
        todraw.repaint();
    }

    private ScrollEvent generateScrollEvent(Point tempCaret_, Point col_row_) {
        int direction = tempCaret_.y > this._caret.y ? (tempCaret_.x > this._caret.x ? 104 : (tempCaret_.x < this._caret.x ? 105 : 102)) : (tempCaret_.y < this._caret.y ? (tempCaret_.x > this._caret.x ? 106 : (tempCaret_.x < this._caret.x ? 107 : 103)) : (tempCaret_.x > this._caret.x ? 100 : 101));
        return new ScrollEvent(this, direction, col_row_);
    }
}

