/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Toolkit;
import charva.awt.event.ActionEvent;
import charva.awt.event.KeyEvent;
import charvax.swing.BoxLayout;
import charvax.swing.JFrame;
import charvax.swing.JMenu;
import charvax.swing.JMenuItem;
import java.util.Vector;

public class JPopupMenu
extends JFrame {
    protected boolean _wasCancelled;
    protected boolean _leftWasPressed;
    protected boolean _rightWasPressed;
    private Component _invoker;

    public JPopupMenu(Vector items_) {
        for (int i = 0; i < items_.size(); ++i) {
            Object o = items_.elementAt(i);
            this.add((Component)o);
        }
        this.setLayout(new BoxLayout(this, 101));
        this.pack();
    }

    public void setInvoker(Component invoker_) {
        this._invoker = invoker_;
        this.setForeground(invoker_.getForeground());
        this.setBackground(invoker_.getBackground());
    }

    public Component getInvoker() {
        return this._invoker;
    }

    public JMenuItem getMenuItem(int index_) {
        Object o = this._components.elementAt(index_);
        if (o instanceof JMenuItem) {
            return (JMenuItem)o;
        }
        return null;
    }

    public JMenuItem getFirstMenuItem() {
        for (int i = 0; i < this._components.size(); ++i) {
            if (!(this._components.elementAt(i) instanceof JMenuItem)) continue;
            return (JMenuItem)this._components.elementAt(i);
        }
        throw new RuntimeException("A JPopupMenu should contain at least one JMenuItem");
    }

    public int getComponentIndex(Component c) {
        return this._components.indexOf(c);
    }

    public void processKeyEvent(KeyEvent e) {
        this._wasCancelled = false;
        this._leftWasPressed = false;
        this._rightWasPressed = false;
        if (!this._visible) {
            return;
        }
        int key = e.getKeyCode();
        Toolkit term = Toolkit.getDefaultToolkit();
        if (key == 259) {
            super.previousFocus();
        } else if (key == 258) {
            super.nextFocus();
        } else if (key == 260) {
            this._leftWasPressed = true;
            this.hide();
        } else if (key == 261) {
            this._rightWasPressed = true;
            this.hide();
        } else if (key == 343) {
            JMenuItem item = (JMenuItem)super.getCurrentFocus();
            this._activate(item);
            e.consume();
        } else if (key == 263 || key == 27) {
            this._wasCancelled = true;
            this.hide();
        } else {
            char keyLower = Character.toLowerCase((char)key);
            for (int i = 0; i < this._components.size(); ++i) {
                char mnemonicLower;
                JMenuItem item = this.getMenuItem(i);
                if (item == null || item.getMnemonic() == -1 || keyLower != (mnemonicLower = Character.toLowerCase((char)item.getMnemonic()))) continue;
                this._activate(item);
                return;
            }
            term.beep();
        }
    }

    public boolean wasCancelled() {
        return this._wasCancelled;
    }

    boolean leftWasPressed() {
        return this._leftWasPressed;
    }

    boolean rightWasPressed() {
        return this._rightWasPressed;
    }

    private void _activate(JMenuItem item_) {
        if (item_ instanceof JMenu) {
            JMenu menu = (JMenu)item_;
            menu.setPopupMenuVisible(true);
            if (menu.getPopupMenu().leftWasPressed()) {
                Toolkit.getDefaultToolkit().fireKeystroke(260);
            } else if (menu.getPopupMenu().rightWasPressed()) {
                Toolkit.getDefaultToolkit().fireKeystroke(261);
            } else if (!menu.getPopupMenu().wasCancelled()) {
                this.hide();
            }
        } else {
            ActionEvent evt = new ActionEvent(item_, item_.getActionCommand());
            Toolkit term = Toolkit.getDefaultToolkit();
            term.getSystemEventQueue().postEvent(evt);
            this.hide();
        }
    }

    public String toString() {
        String str = "JPopupMenu: [";
        for (int i = 0; i < this.getComponentCount(); ++i) {
            str = str + this.getMenuItem(i);
            str = str + " ";
        }
        return str + "]";
    }
}

