/*
 * Decompiled with CFR 0.152.
 */
package charvax.swing;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.IllegalComponentStateException;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.event.KeyEvent;
import charvax.swing.JMenu;

public class JMenuBar
extends Container {
    public JMenuBar() {
        this._origin = new Point(1, 1);
    }

    public JMenu add(JMenu menu_) {
        JMenu jmenu = menu_;
        super.add(jmenu);
        return jmenu;
    }

    public int getMenuCount() {
        return super.getComponentCount();
    }

    public JMenu getMenu(int index_) {
        return (JMenu)super.getComponent(index_);
    }

    public JMenu getMenu(String text_) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu menu = this.getMenu(i);
            if (!menu.getText().equals(text_)) continue;
            return menu;
        }
        throw new IllegalArgumentException("menubar does not contain menu \"" + text_ + "\"");
    }

    public void draw() {
        Point origin = this.getLocationOnScreen();
        Toolkit term = Toolkit.getDefaultToolkit();
        int colorpair = this.getCursesColor();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.getSize().width; ++i) {
            buf.append(' ');
        }
        term.setCursor(origin);
        term.addString(buf.toString(), Toolkit.A_REVERSE, colorpair);
        Component[] menus = super.getComponents();
        int x = 0;
        for (int i = 0; i < menus.length; ++i) {
            menus[i].setLocation(x, 0);
            menus[i].draw();
            x += menus[i].getWidth();
        }
    }

    public void processKeyEvent(KeyEvent ke_) {
        int key = ke_.getKeyCode();
        if (key == 9) {
            this.getParent().nextFocus();
            ke_.consume();
            return;
        }
        if (key == 353) {
            this.getParent().previousFocus();
            ke_.consume();
            return;
        }
        if (key == 261) {
            Component currentFocus = super.getCurrentFocus();
            int menuCount = this.getMenuCount();
            int i = 0;
            for (i = 0; i < menuCount && currentFocus != super.getComponent(i); ++i) {
            }
            i = i == menuCount - 1 ? 0 : ++i;
            this.getMenu(i).requestFocus();
            ke_.consume();
        } else if (key == 260) {
            Component currentFocus = super.getCurrentFocus();
            int menuCount = this.getMenuCount();
            int i = 0;
            for (i = 0; i < menuCount && currentFocus != super.getComponent(i); ++i) {
            }
            i = i == 0 ? menuCount - 1 : --i;
            this.getMenu(i).requestFocus();
            ke_.consume();
        } else {
            char keyLower = Character.toLowerCase((char)key);
            for (int i = 0; i < this._components.size(); ++i) {
                char mnemonicLower;
                JMenu menu = this.getMenu(i);
                if (menu == null || menu.getMnemonic() == -1 || keyLower != (mnemonicLower = Character.toLowerCase((char)menu.getMnemonic()))) continue;
                menu.doClick();
                ke_.consume();
                return;
            }
            super.processKeyEvent(ke_);
        }
    }

    public Dimension minimumSize() {
        int width = 0;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            width += this.getMenu(i).getText().length() + 1;
        }
        return new Dimension(width, 1);
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getWidth() {
        int minwidth;
        Container parent = this.getParent();
        if (parent == null) {
            throw new IllegalComponentStateException("can't get menubar size before it has been added to a frame");
        }
        int parentwidth = parent.getWidth() - 2;
        int width = parentwidth > (minwidth = this.minimumSize().width) ? parentwidth : minwidth;
        return width;
    }

    public int getHeight() {
        return 1;
    }

    public void debug(int level_) {
        for (int i = 0; i < level_; ++i) {
            System.err.print("    ");
        }
        System.err.println(this.toString());
    }

    public String toString() {
        return "JMenuBar";
    }

    private int getMenuAt(int x, int y) {
        Point origin = this.getLocationOnScreen();
        int index = origin.x;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            String menutext = this.getMenu(i).getText();
            if (x >= (index += menutext.length() + 1)) continue;
            return i;
        }
        return -1;
    }

    Point getPopupMenuLocation(JMenu menu_) {
        Point origin = this.getLocationOnScreen();
        int offset = 0;
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu menu = this.getMenu(i);
            if (menu == menu_) {
                return origin.addOffset(offset, 1);
            }
            String menutext = menu.getText();
            offset += menutext.length() + 1;
        }
        throw new IllegalArgumentException("specified menu not in menubar");
    }
}

