/*
 * Decompiled with CFR 0.152.
 */
package charva.awt.util;

import charva.awt.Component;
import charva.awt.Dialog;
import charva.awt.FlowLayout;
import charva.awt.Frame;
import charva.awt.Point;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.FocusEvent;
import charva.awt.event.FocusListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charvax.swing.JLabel;
import charvax.swing.JOptionPane;
import charvax.swing.JPanel;
import charvax.swing.JTextField;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateEntryField
extends JPanel
implements KeyListener,
FocusListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$util$DateEntryField == null ? (class$charva$awt$util$DateEntryField = DateEntryField.class$("charva.awt.util.DateEntryField")) : class$charva$awt$util$DateEntryField));
    private JTextField _yearField = new JTextField(4);
    private JTextField _monthField = new JTextField(2);
    private JTextField _dayField = new JTextField(2);
    private GregorianCalendar _cal;
    private Window _owner;
    static /* synthetic */ Class class$charva$awt$util$DateEntryField;

    public DateEntryField(Frame owner_) {
        this(owner_, TimeZone.getDefault());
    }

    public DateEntryField(Frame owner_, TimeZone zone_) {
        this._owner = owner_;
        this.init(zone_);
    }

    public DateEntryField(Dialog owner_) {
        this(owner_, TimeZone.getDefault());
    }

    public DateEntryField(Dialog owner_, TimeZone zone_) {
        this._owner = owner_;
        this.init(zone_);
    }

    private void init(TimeZone zone_) {
        this.setLayout(new FlowLayout(1, 0, 0));
        this._cal = new GregorianCalendar(zone_);
        this.add(this._yearField);
        this._yearField.addKeyListener(this);
        this._yearField.addFocusListener(this);
        this.add(new JLabel("/"));
        this.add(this._monthField);
        this._monthField.addKeyListener(this);
        this._monthField.addFocusListener(this);
        this.add(new JLabel("/"));
        this.add(this._dayField);
        this._dayField.addKeyListener(this);
        this._dayField.addFocusListener(this);
    }

    public void keyPressed(KeyEvent e_) {
    }

    public void keyReleased(KeyEvent e_) {
    }

    public void keyTyped(KeyEvent e_) {
        Component source;
        int key = e_.getKeyCode();
        if (key < 48 || key > 57) {
            Toolkit.getDefaultToolkit().beep();
            e_.consume();
        }
        if ((source = (Component)e_.getSource()) == this._yearField && this._yearField.getText().length() < 4) {
            return;
        }
        if (source == this._monthField && this._monthField.getText().length() < 2) {
            return;
        }
        if (source == this._dayField && this._dayField.getText().length() < 2) {
            return;
        }
        Toolkit.getDefaultToolkit().beep();
        e_.consume();
    }

    public void focusGained(FocusEvent fe_) {
    }

    public void focusLost(FocusEvent e_) {
        Component source = (Component)e_.getSource();
        Point origin = this.getLocationOnScreen();
        try {
            if (source == this._yearField) {
                if (this._yearField.getText().equals("")) {
                    String[] msgs = new String[]{"A valid year must be ", "entered in this field "};
                    JOptionPane.showMessageDialog(this._yearField, msgs, "Error", 100);
                    this._yearField.requestFocus();
                } else {
                    int year = Integer.parseInt(this._yearField.getText());
                    this._cal.set(1, year);
                }
            } else if (source == this._monthField) {
                int month;
                if (!this._monthField.getText().equals("") && (month = Integer.parseInt(this._monthField.getText())) >= 1 && month <= 12) {
                    this._cal.clear(5);
                    this._cal.set(2, month - 1);
                    return;
                }
                String[] msgs = new String[]{"The month must be", "between 1 and 12"};
                JOptionPane.showMessageDialog(this._monthField, msgs, "Error", 100);
                this._monthField.requestFocus();
            } else if (source == this._dayField) {
                int day;
                int maxday = this._cal.getActualMaximum(5);
                if (!this._dayField.getText().equals("") && (day = Integer.parseInt(this._dayField.getText())) >= 1 && day <= maxday) {
                    this._cal.set(5, day);
                    return;
                }
                String[] msgs = new String[]{"The day must be", "between 1 and " + maxday};
                JOptionPane.showMessageDialog(this._dayField, msgs, "Error", 100);
                this._dayField.requestFocus();
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)"Number format exception");
        }
    }

    public void set() {
        int year = this._cal.get(1);
        this._yearField.setText(Integer.toString(year));
        int month = this._cal.get(2) + 1;
        this._monthField.setText(Integer.toString(month));
        int day = this._cal.get(5);
        this._dayField.setText(Integer.toString(day));
    }

    public void setYear(int year_) {
        this._yearField.setText(Integer.toString(year_));
        this._cal.set(1, year_);
    }

    public void setMonth(int month_) {
        this._monthField.setText(Integer.toString(month_));
        this._cal.set(2, month_ - 1);
    }

    public void setDay(int day_) {
        this._dayField.setText(Integer.toString(day_));
        this._cal.set(5, day_);
    }

    public int getYear() {
        return Integer.parseInt(this._yearField.getText());
    }

    public int getMonth() {
        return Integer.parseInt(this._monthField.getText());
    }

    public int getDay() {
        return Integer.parseInt(this._dayField.getText());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

