/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.GridBagConstraints;
import charva.awt.Insets;
import charva.awt.LayoutManager2;
import java.util.Enumeration;
import java.util.Vector;

public class GridBagLayout
implements LayoutManager2 {
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;
    private Vector _components = new Vector();
    private Vector _constraints = new Vector();
    private int _rows;
    private int _columns;
    private int[] _calculatedRowHeights;
    private int[] _calculatedColumnWidths;
    private double[] _calculatedRowWeights;
    private double[] _calculatedColumnWeights;
    private double _totalweightx = 0.0;
    private double _totalweighty = 0.0;

    public Dimension minimumSize(Container container_) {
        int i;
        GridBagConstraints gbc;
        Enumeration e;
        this._rows = 0;
        this._columns = 0;
        Enumeration e1 = this._constraints.elements();
        while (e1.hasMoreElements()) {
            GridBagConstraints gbc2 = (GridBagConstraints)e1.nextElement();
            if (gbc2.gridx + gbc2.gridwidth > this._columns) {
                this._columns = gbc2.gridx + gbc2.gridwidth;
            }
            if (gbc2.gridy + gbc2.gridheight <= this._rows) continue;
            this._rows = gbc2.gridy + gbc2.gridheight;
        }
        this._calculatedRowHeights = new int[this._rows];
        this._calculatedRowWeights = new double[this._rows];
        this._calculatedColumnWidths = new int[this._columns];
        this._calculatedColumnWeights = new double[this._columns];
        int[] width_left = new int[this._components.size()];
        int[] height_left = new int[this._components.size()];
        e1 = this._components.elements();
        Enumeration e2 = this._constraints.elements();
        int i2 = 0;
        while (e1.hasMoreElements()) {
            Component c = (Component)e1.nextElement();
            GridBagConstraints gbc3 = (GridBagConstraints)e2.nextElement();
            Insets insets = gbc3.insets;
            Dimension minsize = c.minimumSize();
            width_left[i2] = minsize.width + insets.left + insets.right;
            height_left[i2] = minsize.height + insets.top + insets.bottom;
            ++i2;
        }
        for (int row = 0; row < this._rows; ++row) {
            this._calculatedRowHeights[row] = 0;
            e = this._constraints.elements();
            int i3 = 0;
            while (e.hasMoreElements()) {
                gbc = (GridBagConstraints)e.nextElement();
                if (row == gbc.gridy + gbc.gridheight - 1 && height_left[i3] > this._calculatedRowHeights[row]) {
                    this._calculatedRowHeights[row] = height_left[i3];
                }
                ++i3;
            }
            e = this._constraints.elements();
            i3 = 0;
            while (e.hasMoreElements()) {
                gbc = (GridBagConstraints)e.nextElement();
                if (row >= gbc.gridy && row < gbc.gridy + gbc.gridheight) {
                    int n = i3;
                    height_left[n] = height_left[n] - this._calculatedRowHeights[row];
                }
                ++i3;
            }
        }
        for (int column = 0; column < this._columns; ++column) {
            this._calculatedColumnWidths[column] = 0;
            e = this._constraints.elements();
            int i4 = 0;
            while (e.hasMoreElements()) {
                gbc = (GridBagConstraints)e.nextElement();
                if (column == gbc.gridx + gbc.gridwidth - 1 && width_left[i4] > this._calculatedColumnWidths[column]) {
                    this._calculatedColumnWidths[column] = width_left[i4];
                }
                ++i4;
            }
            e = this._constraints.elements();
            i4 = 0;
            while (e.hasMoreElements()) {
                gbc = (GridBagConstraints)e.nextElement();
                if (column >= gbc.gridx && column < gbc.gridx + gbc.gridwidth) {
                    int n = i4;
                    width_left[n] = width_left[n] - this._calculatedColumnWidths[column];
                }
                ++i4;
            }
        }
        e2 = this._constraints.elements();
        while (e2.hasMoreElements()) {
            int i5;
            GridBagConstraints gbc4 = (GridBagConstraints)e2.nextElement();
            for (i5 = gbc4.gridx; i5 < gbc4.gridx + gbc4.gridwidth; ++i5) {
                if (!(gbc4.weightx > this._calculatedColumnWeights[i5])) continue;
                this._calculatedColumnWeights[i5] = gbc4.weightx;
            }
            for (i5 = gbc4.gridy; i5 < gbc4.gridy + gbc4.gridheight; ++i5) {
                if (!(gbc4.weighty > this._calculatedRowWeights[i5])) continue;
                this._calculatedRowWeights[i5] = gbc4.weighty;
            }
        }
        Insets insets = container_.getInsets();
        int totalwidth = insets.left + insets.right;
        int totalheight = insets.top + insets.bottom;
        for (i = 0; i < this._columns; ++i) {
            totalwidth += this._calculatedColumnWidths[i];
            this._totalweightx += this._calculatedColumnWeights[i];
        }
        for (i = 0; i < this._rows; ++i) {
            totalheight += this._calculatedRowHeights[i];
            this._totalweighty += this._calculatedRowWeights[i];
        }
        return new Dimension(totalwidth, totalheight);
    }

    public void doLayout(Container container_) {
        Insets insets = container_.getInsets();
        Dimension size = container_.getSize();
        Dimension minsize = this.minimumSize(container_);
        int extraColumns = size.width - minsize.width;
        int extraRows = size.height - minsize.height;
        Enumeration e1 = this._components.elements();
        Enumeration e2 = this._constraints.elements();
        while (e1.hasMoreElements()) {
            Component c = (Component)e1.nextElement();
            GridBagConstraints gbc = (GridBagConstraints)e2.nextElement();
            int left = insets.left;
            if (this._totalweightx == 0.0) {
                left += extraColumns / 2;
            }
            for (int i = 0; i < gbc.gridx; ++i) {
                left += this._calculatedColumnWidths[i];
                if (this._totalweightx == 0.0) continue;
                left = (int)((double)left + (double)extraColumns * this._calculatedColumnWeights[i] / this._totalweightx);
            }
            int right = left;
            for (int i = 0; i < gbc.gridwidth; ++i) {
                right += this._calculatedColumnWidths[gbc.gridx + i];
            }
            int top = insets.top;
            if (this._totalweighty == 0.0) {
                top += extraRows / 2;
            }
            for (int i = 0; i < gbc.gridy; ++i) {
                top += this._calculatedRowHeights[i];
                if (this._totalweighty == 0.0) continue;
                top = (int)((double)top + (double)extraRows * this._calculatedRowWeights[i] / this._totalweighty);
            }
            int bottom = top;
            for (int i = 0; i < gbc.gridheight; ++i) {
                bottom += this._calculatedRowHeights[gbc.gridy + i];
            }
            if (c instanceof Container) {
                Container cont = (Container)c;
                if (!cont.isValid()) {
                    cont.setSize(cont.minimumSize());
                }
                switch (gbc.fill) {
                    case 200: {
                        break;
                    }
                    case 201: {
                        cont.setWidth(right - left);
                        break;
                    }
                    case 202: {
                        cont.setHeight(bottom - top);
                        break;
                    }
                    case 203: {
                        cont.setSize(right - left, bottom - top);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid fill parameter");
                    }
                }
                cont.doLayout();
            }
            int cx = 0;
            switch (gbc.anchor) {
                case 106: 
                case 107: 
                case 108: {
                    cx = left + gbc.insets.left;
                    break;
                }
                case 102: 
                case 103: 
                case 104: {
                    cx = right - gbc.insets.right - c.getSize().width;
                    break;
                }
                case 100: 
                case 101: 
                case 105: {
                    cx = left + gbc.insets.left + (right - gbc.insets.right);
                    cx -= c.getSize().width;
                    cx /= 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid anchor paremeter");
                }
            }
            int cy = 0;
            switch (gbc.anchor) {
                case 101: 
                case 102: 
                case 108: {
                    cy = top + gbc.insets.top;
                    break;
                }
                case 104: 
                case 105: 
                case 106: {
                    cy = bottom - gbc.insets.bottom - c.getSize().height;
                    break;
                }
                case 100: 
                case 103: 
                case 107: {
                    cy = top + gbc.insets.top + (bottom - gbc.insets.bottom);
                    cy -= c.getSize().height;
                    cy /= 2;
                }
            }
            c.setLocation(cx, cy);
        }
    }

    public void addLayoutComponent(Component component_, Object constraint_) {
        this._components.add(component_);
        GridBagConstraints constraint = (GridBagConstraints)constraint_;
        GridBagConstraints newc = new GridBagConstraints();
        newc.gridx = constraint.gridx;
        newc.gridy = constraint.gridy;
        newc.gridwidth = constraint.gridwidth;
        newc.gridheight = constraint.gridheight;
        newc.weightx = constraint.weightx;
        newc.weighty = constraint.weighty;
        newc.anchor = constraint.anchor;
        newc.fill = constraint.fill;
        newc.insets = new Insets(constraint.insets.top, constraint.insets.left, constraint.insets.bottom, constraint.insets.right);
        newc.ipadx = constraint.ipadx;
        newc.ipady = constraint.ipady;
        this._constraints.add(newc);
    }

    public void invalidateLayout(Container target_) {
    }
}

