/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Component;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.Insets;
import charva.awt.LayoutManager;
import java.util.Enumeration;
import java.util.Vector;

public class FlowLayout
implements LayoutManager {
    private int _align = 2;
    private int _hgap = 1;
    private int _vgap = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;

    public FlowLayout() {
        this(2, 1, 0);
    }

    public FlowLayout(int align_, int hgap_, int vgap_) {
        this._align = align_;
        this._hgap = hgap_;
        this._vgap = vgap_;
    }

    public void setAlignment(int align_) {
        this._align = align_;
    }

    public int getAlignment() {
        return this._align;
    }

    public Dimension minimumSize(Container container_) {
        int width = 0;
        int height = 0;
        Component[] components = container_.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Dimension d = components[i].minimumSize();
            if (i != 0) {
                width += this._hgap;
            }
            width += d.width;
            if (d.height <= height) continue;
            height = d.height;
        }
        Insets insets = container_.getInsets();
        return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
    }

    public void doLayout(Container container_) {
        int availableWidth;
        Insets insets = container_.getInsets();
        int widthLeft = availableWidth = container_.getSize().width - insets.left - insets.right;
        int heightLeft = container_.getSize().height - insets.top - insets.bottom;
        int voffset = insets.top;
        Component[] components = container_.getComponents();
        Vector<Component> localvector = new Vector<Component>();
        for (int i = 0; i < components.length; ++i) {
            Container cont;
            Component c = components[i];
            if (c instanceof Container && !(cont = (Container)c).isValid()) {
                cont.setSize(cont.minimumSize());
                cont.doLayout();
            }
            int requiredWidth = c.getSize().width;
            if (i != 0) {
                requiredWidth += this._hgap;
            }
            if (requiredWidth > widthLeft) {
                int rowHeight = 0;
                if (localvector.size() != 0) {
                    rowHeight = this.layoutRow(container_, localvector, widthLeft, heightLeft, voffset);
                    localvector.removeAllElements();
                }
                voffset += rowHeight + this._vgap;
                widthLeft = availableWidth;
                heightLeft -= rowHeight + this._vgap;
            }
            widthLeft -= requiredWidth;
            localvector.add(c);
        }
        this.layoutRow(container_, localvector, widthLeft, heightLeft, voffset);
    }

    private int layoutRow(Container container_, Vector components_, int widthleft_, int heightleft_, int voffset_) {
        int hoffset = 0;
        int rowHeight = 0;
        Insets insets = container_.getInsets();
        switch (this._align) {
            case 1: {
                hoffset = insets.left;
                break;
            }
            case 2: {
                hoffset = insets.left + widthleft_ / 2;
                break;
            }
            case 3: {
                hoffset = insets.left + widthleft_;
            }
        }
        Enumeration e = components_.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c.getSize().height > rowHeight) {
                rowHeight = c.getSize().height;
            }
            if (rowHeight > heightleft_) {
                container_.remove(c);
                continue;
            }
            c.setLocation(hoffset, voffset_);
            hoffset += c.getSize().width + this._hgap;
        }
        return rowHeight;
    }
}

