/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Toolkit;
import charva.awt.event.AWTEvent;
import charva.awt.event.FocusEvent;
import charva.awt.event.InvocationEvent;
import charva.awt.event.SyncEvent;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventQueue {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$EventQueue == null ? (class$charva$awt$EventQueue = EventQueue.class$("charva.awt.EventQueue")) : class$charva$awt$EventQueue));
    private LinkedList _lowPriorityQueue = new LinkedList();
    private LinkedList _highPriorityQueue = new LinkedList();
    private static volatile EventQueue _instance = null;
    static /* synthetic */ Class class$charva$awt$EventQueue;

    private EventQueue() {
    }

    public static synchronized EventQueue getInstance() {
        if (_instance == null) {
            _instance = new EventQueue();
        }
        return _instance;
    }

    public synchronized void postEvent(AWTEvent evt_) {
        if (evt_.getID() == 7) {
            Toolkit.getDefaultToolkit().setLastFocusEvent((FocusEvent)evt_);
        }
        this.addLast(evt_);
        this.notifyAll();
    }

    public synchronized AWTEvent waitForNextEvent() {
        while (this.queuesAreEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return (AWTEvent)this.removeFirst();
    }

    public synchronized AWTEvent getNextEvent() {
        return (AWTEvent)this.removeFirst();
    }

    public static void invokeLater(Runnable runnable_) {
        EventQueue.getInstance().postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable_));
    }

    public synchronized boolean queuesAreEmpty() {
        return this._lowPriorityQueue.size() == 0 && this._highPriorityQueue.size() == 0;
    }

    private void addLast(AWTEvent evt_) {
        if (evt_ instanceof SyncEvent) {
            this._lowPriorityQueue.addLast(evt_);
        } else {
            this._highPriorityQueue.addLast(evt_);
        }
    }

    private Object removeFirst() {
        if (this._highPriorityQueue.size() > 0) {
            return this._highPriorityQueue.removeFirst();
        }
        if (LOG.isDebugEnabled()) {
            if (this._lowPriorityQueue.size() > 1) {
                LOG.debug((Object)("Coalescing " + this._lowPriorityQueue.size() + " SyncEvents on queue"));
            } else {
                LOG.debug((Object)"1 SyncEvent");
            }
        }
        Object obj = null;
        while (this._lowPriorityQueue.size() > 0) {
            obj = this._lowPriorityQueue.removeFirst();
        }
        return obj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

