/*
 * Decompiled with CFR 0.152.
 */
package charva.awt;

import charva.awt.Color;
import charva.awt.Container;
import charva.awt.Dimension;
import charva.awt.EventQueue;
import charva.awt.IllegalComponentStateException;
import charva.awt.Point;
import charva.awt.Rectangle;
import charva.awt.Toolkit;
import charva.awt.Window;
import charva.awt.event.AWTEvent;
import charva.awt.event.FocusEvent;
import charva.awt.event.FocusListener;
import charva.awt.event.KeyEvent;
import charva.awt.event.KeyListener;
import charva.awt.event.MouseEvent;
import charva.awt.event.PaintEvent;
import charva.awt.event.SyncEvent;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Component {
    private static final Log LOG = LogFactory.getLog((Class)(class$charva$awt$Component == null ? (class$charva$awt$Component = Component.class$("charva.awt.Component")) : class$charva$awt$Component));
    private boolean _hadFocus = false;
    protected Point _origin = new Point(0, 0);
    protected WeakReference _parent = null;
    protected boolean _enabled = true;
    protected boolean _visible = true;
    protected Vector _keyListeners = null;
    protected Vector _focusListeners = null;
    protected float _alignmentX = 0.0f;
    protected float _alignmentY = 0.0f;
    private String _name = "";
    protected Color _foreground = null;
    protected Color _background = null;
    protected int _cursesColor = 0;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    static /* synthetic */ Class class$charva$awt$Component;

    public void setVisible(boolean visible_) {
        if (visible_) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        if (!this._visible) {
            this._visible = true;
            this.repaint();
        }
    }

    public void hide() {
        if (this._visible) {
            this._visible = false;
            if (this.hasFocus()) {
                this.getParent().nextFocus();
                if (this.hasFocus()) {
                    this.getParent().previousFocus();
                    if (this.hasFocus()) {
                        throw new IllegalComponentStateException("cannot hide component; it was the only focusTraversable component in this window");
                    }
                }
            }
            this.repaint();
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public abstract void draw();

    public boolean isDisplayed() {
        Container parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.isDisplayed();
    }

    public Point getLocation() {
        return new Point(this._origin);
    }

    public void setLocation(Point origin_) {
        this._origin = new Point(origin_);
    }

    public void setLocation(int x_, int y_) {
        this._origin.x = x_;
        this._origin.y = y_;
    }

    public Point getLocationOnScreen() {
        Container parent = this.getParent();
        if (parent == null) {
            throw new IllegalComponentStateException("cannot get component location before it has been added to a container");
        }
        return parent.getLocationOnScreen().addOffset(this._origin);
    }

    public abstract Dimension getSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public Rectangle getBounds() {
        return new Rectangle(this._origin, this.getSize());
    }

    public void setBounds(Rectangle bounds) {
        this.setLocation(bounds.getLeft(), bounds.getTop());
    }

    public void setBounds(int top_, int left_, int bottom_, int right_) {
        this.setLocation(left_, top_);
    }

    public void setBounds(Point topleft_, Dimension size_) {
        this.setLocation(topleft_);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    public abstract Dimension minimumSize();

    public void setParent(Container container_) {
        this._parent = new WeakReference<Container>(container_);
        if (this.getForeground() == null) {
            this.setForeground(container_.getForeground());
        }
        if (this.getBackground() == null) {
            this.setBackground(container_.getBackground());
        }
    }

    public Container getParent() {
        if (this._parent == null) {
            return null;
        }
        return (Container)this._parent.get();
    }

    public void addKeyListener(KeyListener kl_) {
        if (this._keyListeners == null) {
            this._keyListeners = new Vector();
        }
        if (!this._keyListeners.contains(kl_)) {
            this._keyListeners.add(kl_);
        }
    }

    public void addFocusListener(FocusListener fl_) {
        if (this._focusListeners == null) {
            this._focusListeners = new Vector();
        }
        if (!this._focusListeners.contains(fl_)) {
            this._focusListeners.add(fl_);
        }
    }

    protected void processEvent(AWTEvent evt_) {
        if (evt_ instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)evt_;
            this.getAncestorWindow().processKeyEvent(ke);
        } else if (evt_ instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)evt_);
        } else if (evt_ instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)evt_;
            this.processMouseEvent(e);
        }
    }

    public void processKeyEvent(KeyEvent ke_) {
        if (this._keyListeners != null) {
            Enumeration e = this._keyListeners.elements();
            while (e.hasMoreElements()) {
                KeyListener kl = (KeyListener)e.nextElement();
                if (ke_.getID() == 1) {
                    kl.keyPressed(ke_);
                } else if (ke_.getID() == 2) {
                    kl.keyTyped(ke_);
                }
                if (!ke_.isConsumed()) continue;
                break;
            }
        }
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getButton() == 1 && e.getModifiers() == 100 && this.isFocusTraversable()) {
            this.requestFocus();
        }
    }

    public void processFocusEvent(FocusEvent fe_) {
        LOG.debug((Object)("processFocusEvent:" + this.toString() + " ev:" + fe_.toString()));
        if (this._focusListeners != null) {
            Enumeration e = this._focusListeners.elements();
            while (e.hasMoreElements()) {
                FocusListener fl = (FocusListener)e.nextElement();
                if (fe_.getID() == 7) {
                    fl.focusGained(fe_);
                    continue;
                }
                fl.focusLost(fe_);
            }
        }
    }

    public Window getAncestorWindow() {
        if (this instanceof Window) {
            return (Window)this;
        }
        Container ancestor = this.getParent();
        while (!(ancestor instanceof Window)) {
            if (ancestor == null) {
                return null;
            }
            Container nextancestor = ancestor.getParent();
            if (nextancestor == null) {
                return null;
            }
            ancestor = nextancestor;
        }
        return (Window)ancestor;
    }

    public void requestFocus() {
        boolean temporary = false;
        Window ancestor = this.getAncestorWindow();
        Component currentFocus = ancestor.getCurrentFocus();
        Window sourcewin = Toolkit.getDefaultToolkit().getTopWindow();
        Component currentFocusX = sourcewin.getCurrentFocus();
        if (currentFocus != this || currentFocusX == this && !this._hadFocus) {
            FocusEvent evt;
            this._hadFocus = true;
            EventQueue evtQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            FocusEvent lastEvt = Toolkit.getDefaultToolkit().getLastFocusEvent();
            if (lastEvt != null) {
                currentFocus = (Component)lastEvt.getSource();
                temporary = currentFocus != null && currentFocus.getAncestorWindow() != null && currentFocus.getAncestorWindow().isEnabled() && currentFocus.getAncestorWindow() != ancestor;
                evt = new FocusEvent(6, currentFocus, temporary, this);
                evtQueue.postEvent(evt);
            } else {
                currentFocus = null;
            }
            evt = new FocusEvent(7, this, temporary, currentFocus);
            evtQueue.postEvent(evt);
            this.getParent().setFocus(this);
            this.repaint();
        }
    }

    public boolean hasFocus() {
        Window ancestor = this.getAncestorWindow();
        if (ancestor == null) {
            return false;
        }
        return ancestor.getCurrentFocus() == this;
    }

    public boolean isFocusTraversable() {
        return this._enabled && this._visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTotallyObscured() {
        Rectangle bounds = this.getBounds();
        Window ancestor = this.getAncestorWindow();
        Vector windowList = Toolkit.getDefaultToolkit().getWindowList();
        boolean obscured = false;
        Vector vector = windowList;
        synchronized (vector) {
            Window w;
            int i;
            for (i = 0; i < windowList.size() && (w = (Window)windowList.elementAt(i)) != ancestor; ++i) {
            }
            ++i;
            while (i < windowList.size()) {
                w = (Window)windowList.elementAt(i);
                Rectangle windowRect = w.getBounds();
                if (bounds.equals(windowRect.intersection(bounds))) {
                    obscured = true;
                    break;
                }
                ++i;
            }
        }
        return obscured;
    }

    public float getAlignmentX() {
        return this._alignmentX;
    }

    public float getAlignmentY() {
        return this._alignmentY;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setForeground(Color color_) {
        this._foreground = color_;
        this.validateCursesColor();
    }

    public void setBackground(Color color_) {
        this._background = color_;
        this.validateCursesColor();
    }

    public void setEnabled(boolean flag_) {
        this._enabled = flag_;
        this.repaint();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void invalidate() {
        Container parent = this.getParent();
        if (parent != null) {
            parent.invalidate();
        }
    }

    public void validate() {
    }

    public void repaint() {
        if (!this.isDisplayed()) {
            return;
        }
        PaintEvent evt = new PaintEvent(this, this.getBounds());
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        queue.postEvent(evt);
    }

    public void requestSync() {
        SyncEvent evt = new SyncEvent(this);
        EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        queue.postEvent(evt);
    }

    public boolean isValid() {
        return true;
    }

    public abstract void debug(int var1);

    public void setName(String name_) {
        this._name = name_;
    }

    public String getName() {
        return this._name;
    }

    public void validateCursesColor() {
        if (this._foreground == null || this._background == null) {
            return;
        }
        this._cursesColor = Color.getCursesColor(this._foreground, this._background);
    }

    public int getCursesColor() {
        return this._cursesColor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

