/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.internal.ui.views.executables.SourceFilesViewer;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class SourceFilesLabelProvider
extends TreeColumnViewerLabelProvider {
    private SourceFilesViewer viewer;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public SourceFilesLabelProvider(SourceFilesViewer viewer) {
        super((IBaseLabelProvider)new CElementLabelProvider());
        this.viewer = viewer;
    }

    public void update(ViewerCell cell) {
        super.update(cell);
        int orgColumnIndex = cell.getColumnIndex();
        if (orgColumnIndex == 0) {
            if (cell.getElement() instanceof String) {
                cell.setText((String)cell.getElement());
                Font boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.viewer.getTree().getFont()).setStyle(1));
                cell.setFont(boldFont);
            }
        } else if (orgColumnIndex == 1) {
            ITranslationUnit tu;
            IPath path;
            cell.setText(null);
            if (cell.getElement() instanceof ITranslationUnit && (path = (tu = (ITranslationUnit)cell.getElement()).getLocation()) != null) {
                cell.setText(path.toOSString());
                if (path.toFile().exists()) {
                    cell.setForeground(Display.getDefault().getSystemColor(2));
                } else {
                    cell.setForeground(Display.getDefault().getSystemColor(15));
                }
            }
            cell.setImage(null);
        } else if (orgColumnIndex == 2) {
            cell.setText(null);
            if (cell.getElement() instanceof ITranslationUnit) {
                Executable executable = (Executable)this.viewer.getInput();
                Path path = new Path(executable.getOriginalLocation((ITranslationUnit)cell.getElement()));
                cell.setText(executable.getOriginalLocation((ITranslationUnit)cell.getElement()));
                if (path.toFile().exists()) {
                    cell.setForeground(Display.getDefault().getSystemColor(2));
                } else {
                    cell.setForeground(Display.getDefault().getSystemColor(15));
                }
            }
            cell.setImage(null);
        } else if (orgColumnIndex == 3) {
            ITranslationUnit tu;
            IPath path;
            cell.setText(null);
            if (cell.getElement() instanceof ITranslationUnit && (path = (tu = (ITranslationUnit)cell.getElement()).getLocation()) != null && path.toFile().exists()) {
                long fileLength = path.toFile().length();
                cell.setText(Long.toString(fileLength));
            }
            cell.setImage(null);
        } else if (orgColumnIndex == 4) {
            ITranslationUnit tu;
            IPath path;
            cell.setText(null);
            if (cell.getElement() instanceof ITranslationUnit && (path = (tu = (ITranslationUnit)cell.getElement()).getLocation()) != null && path.toFile().exists()) {
                long modified = path.toFile().lastModified();
                String dateTimeString = DateFormat.getDateTimeInstance((int)3, (int)3).format(new Date(modified));
                cell.setText(dateTimeString);
            }
            cell.setImage(null);
        } else if (orgColumnIndex == 5) {
            String fileExtension;
            ITranslationUnit tu;
            IPath path;
            cell.setText(null);
            if (cell.getElement() instanceof ITranslationUnit && (path = (tu = (ITranslationUnit)cell.getElement()).getLocation()) != null && (fileExtension = path.getFileExtension()) != null) {
                cell.setText(fileExtension.toLowerCase());
            }
            cell.setImage(null);
        }
    }
}

