/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.executables;

import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ExecutablesManager;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeEvent;
import org.eclipse.cdt.debug.core.executables.IExecutablesChangeListener;
import org.eclipse.cdt.debug.internal.ui.views.executables.BaseViewer;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesContentProvider;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesView;
import org.eclipse.cdt.debug.internal.ui.views.executables.ExecutablesViewerComparator;
import org.eclipse.cdt.debug.internal.ui.views.executables.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.progress.UIJob;

public class ExecutablesViewer
extends BaseViewer
implements IExecutablesChangeListener {
    private static final String P_COLUMN_ORDER_KEY_EXE = "columnOrderKeyEXE";
    private static final String P_SORTED_COLUMN_INDEX_KEY_EXE = "sortedColumnIndexKeyEXE";
    private static final String P_COLUMN_SORT_DIRECTION_KEY_EXE = "columnSortDirectionKeyEXE";
    private static final String P_VISIBLE_COLUMNS_KEY_EXE = "visibleColumnsKeyEXE";
    public TreeColumn projectColumn;

    public ExecutablesViewer(ExecutablesView executablesView, Composite parent, int style) {
        super(executablesView, parent, style);
        int ops = 19;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        ExecutablesDropAdapter adapter = new ExecutablesDropAdapter((Viewer)this);
        adapter.setFeedbackEnabled(false);
        this.addDropSupport(ops | 0x10, transfers, (DropTargetListener)adapter);
        ExecutablesContentProvider exeContentProvider = new ExecutablesContentProvider(this);
        this.setContentProvider((IContentProvider)exeContentProvider);
        this.setLabelProvider((IBaseLabelProvider)exeContentProvider);
        this.getTree().setHeaderVisible(true);
        this.getTree().setLinesVisible(true);
        executablesView.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getTree().setData(".uid", (Object)"ExecutablesViewerTree");
        this.createColumns();
        this.setInput(ExecutablesManager.getExecutablesManager());
        MenuManager popupMenuManager = new MenuManager("#PopupMenu");
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)ExecutablesViewer.this.getExecutablesView().refreshAction);
                manager.add((IAction)ExecutablesViewer.this.getExecutablesView().importAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        this.getExecutablesView().getSite().registerContextMenu(popupMenuManager, this.getExecutablesView().getSite().getSelectionProvider());
        Menu menu = popupMenuManager.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
    }

    private void createColumns() {
        this.nameColumn = new TreeColumn(this.getTree(), 0);
        this.nameColumn.setWidth(100);
        this.nameColumn.setText(Messages.ExecutablesViewer_ExecutableName);
        this.nameColumn.setMoveable(true);
        this.nameColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(0));
        this.projectColumn = new TreeColumn(this.getTree(), 0);
        this.projectColumn.setWidth(100);
        this.projectColumn.setMoveable(true);
        this.projectColumn.setText(Messages.ExecutablesViewer_Project);
        this.projectColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(1));
        this.locationColumn = new TreeColumn(this.getTree(), 0);
        this.locationColumn.setWidth(100);
        this.locationColumn.setText(Messages.ExecutablesViewer_Location);
        this.locationColumn.setMoveable(true);
        this.locationColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(2));
        this.sizeColumn = new TreeColumn(this.getTree(), 0);
        this.sizeColumn.setWidth(100);
        this.sizeColumn.setText(Messages.ExecutablesViewer_Size);
        this.sizeColumn.setMoveable(true);
        this.sizeColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(3));
        this.modifiedColumn = new TreeColumn(this.getTree(), 0);
        this.modifiedColumn.setWidth(100);
        this.modifiedColumn.setText(Messages.ExecutablesViewer_Modified);
        this.modifiedColumn.setMoveable(true);
        this.modifiedColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(4));
        this.typeColumn = new TreeColumn(this.getTree(), 0);
        this.typeColumn.setWidth(100);
        this.typeColumn.setText(Messages.ExecutablesViewer_Type);
        this.typeColumn.setMoveable(true);
        this.typeColumn.addSelectionListener((SelectionListener)new BaseViewer.ColumnSelectionAdapter(5));
    }

    protected ViewerComparator getViewerComparator(int sortType) {
        if (sortType == 1) {
            return new ExecutablesViewerComparator(sortType, this.column_sort_order[1]){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    Executable entry1 = (Executable)e1;
                    Executable entry2 = (Executable)e2;
                    return this.getComparator().compare(entry1.getProject().getName(), entry2.getProject().getName()) * ExecutablesViewer.this.column_sort_order[1];
                }
            };
        }
        return new ExecutablesViewerComparator(sortType, this.column_sort_order[sortType]);
    }

    public void executablesChanged(IExecutablesChangeEvent event) {
        final ExecutablesViewer viewer = this;
        UIJob refreshJob = new UIJob(Messages.ExecutablesViewer_RefreshExecutablesView){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IStructuredSelection selection;
                Object firstElement;
                if (viewer.getSelection() != null && viewer.getSelection() instanceof IStructuredSelection && (firstElement = (selection = (IStructuredSelection)viewer.getSelection()).getFirstElement()) instanceof Executable) {
                    Executable executable = (Executable)firstElement;
                    executable.setRefreshSourceFiles(true);
                    viewer.setSelection((ISelection)selection);
                }
                viewer.refresh(null);
                viewer.packColumns();
                return Status.OK_STATUS;
            }
        };
        refreshJob.schedule();
    }

    protected String getColumnOrderKey() {
        return P_COLUMN_ORDER_KEY_EXE;
    }

    protected String getSortedColumnIndexKey() {
        return P_SORTED_COLUMN_INDEX_KEY_EXE;
    }

    protected String getSortedColumnDirectionKey() {
        return P_COLUMN_SORT_DIRECTION_KEY_EXE;
    }

    protected String getVisibleColumnsKey() {
        return P_VISIBLE_COLUMNS_KEY_EXE;
    }

    protected String getDefaultVisibleColumnsValue() {
        return "1,1,1,0,0,0";
    }

    public class ExecutablesDropAdapter
    extends ViewerDropAdapter {
        protected ExecutablesDropAdapter(Viewer viewer) {
            super(viewer);
        }

        public boolean performDrop(Object data) {
            String[] fileNames = (String[])data;
            ExecutablesViewer.this.getExecutablesView().importExecutables(fileNames);
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return FileTransfer.getInstance().isSupportedType(transferType);
        }
    }
}

