/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.views.memory.AddMemoryBlocks;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

public class ViewMemoryActionDelegate
implements IObjectActionDelegate {
    private ICVariable[] variables;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IWorkbenchPage page = CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IViewPart newView = page.showView("org.eclipse.debug.ui.MemoryView", null, 1);
            IMemoryRenderingSite memSite = (IMemoryRenderingSite)newView;
            new AddMemoryBlocks().addMemoryBlocksForVariables(this.variables, memSite);
        }
        catch (ClassCastException e) {
            CDebugUIUtils.openError(ActionMessages.getString("ViewMemoryActionDelegate.ErrorTitle"), ActionMessages.getString("ViewMemoryActionDelegate.CantOpenMemoryView"), e);
        }
        catch (PartInitException e) {
            CDebugUIUtils.openError(ActionMessages.getString("ViewMemoryActionDelegate.ErrorTitle"), ActionMessages.getString("ViewMemoryActionDelegate.CantOpenMemoryView"), (Exception)((Object)e));
        }
        catch (DebugException e) {
            CDebugUIUtils.openError(ActionMessages.getString("ViewMemoryActionDelegate.ErrorTitle"), ActionMessages.getString("ViewMemoryActionDelegate.CantViewMemory"), (Exception)((Object)e));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            ArrayList list = new ArrayList();
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object o : ssel) {
                if (!(o instanceof ICVariable)) continue;
                action.setEnabled(true);
                list.add(o);
            }
            this.setVariables(list.toArray(new ICVariable[list.size()]));
        } else {
            action.setChecked(false);
            action.setEnabled(false);
        }
    }

    protected ICVariable[] getVariables() {
        return this.variables;
    }

    private void setVariables(ICVariable[] variables) {
        this.variables = variables;
    }
}

