/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IMoveToAddress;
import org.eclipse.cdt.debug.core.model.IMoveToLine;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.actions.IMoveToLineTarget;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class MoveToLineAdapter
implements IMoveToLineTarget {
    /*
     * Enabled aggressive block sorting
     */
    public void moveToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IEditorInput input = textEditor.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("MoveToLineAdapter.0");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("MoveToLineAdapter.1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            String fileName = this.getFileName(input);
            IDebugTarget debugTarget = null;
            if (target instanceof CDebugElement) {
                debugTarget = ((CDebugElement)target).getDebugTarget();
            }
            if (debugTarget == null) throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            ITextSelection textSelection = (ITextSelection)selection;
            final int lineNumber = textSelection.getStartLine() + 1;
            if (!(target instanceof IAdaptable)) return;
            final IPath path = this.convertPath(fileName, debugTarget);
            final IMoveToLine moveToLine = (IMoveToLine)((IAdaptable)target).getAdapter(IMoveToLine.class);
            if (moveToLine == null) return;
            if (!moveToLine.canMoveToLine(path.toPortableString(), lineNumber)) return;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        moveToLine.moveToLine(path.toPortableString(), lineNumber);
                    }
                    catch (DebugException e) {
                        MoveToLineAdapter.this.failed(e);
                    }
                }
            };
            this.runInBackground(r);
            return;
        }
        if (!(part instanceof DisassemblyView)) {
            errorMessage = ActionMessages.getString("MoveToLineAdapter.3");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        IEditorInput input = ((DisassemblyView)part).getInput();
        if (!(input instanceof DisassemblyEditorInput)) {
            errorMessage = ActionMessages.getString("MoveToLineAdapter.2");
            throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        final IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
        if (address == null) return;
        if (!(target instanceof IAdaptable)) return;
        final IMoveToAddress moveToAddress = (IMoveToAddress)((IAdaptable)target).getAdapter(IMoveToAddress.class);
        if (moveToAddress == null) return;
        if (!moveToAddress.canMoveToAddress(address)) return;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    moveToAddress.moveToAddress(address);
                }
                catch (DebugException e) {
                    MoveToLineAdapter.this.failed(e);
                }
            }
        };
        this.runInBackground(r);
    }

    public boolean canMoveToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable) {
            if (part instanceof IEditorPart) {
                IMoveToLine moveToLine = (IMoveToLine)((IAdaptable)target).getAdapter(IMoveToLine.class);
                if (moveToLine == null) {
                    return false;
                }
                IEditorPart editorPart = (IEditorPart)part;
                IEditorInput input = editorPart.getEditorInput();
                if (input == null) {
                    return false;
                }
                if (!(editorPart instanceof ITextEditor)) {
                    return false;
                }
                ITextEditor textEditor = (ITextEditor)editorPart;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
                if (document == null) {
                    return false;
                }
                String fileName = null;
                try {
                    fileName = this.getFileName(input);
                }
                catch (CoreException coreException) {}
                if (fileName == null) {
                    return false;
                }
                IDebugTarget debugTarget = null;
                if (target instanceof CDebugElement) {
                    debugTarget = ((CDebugElement)target).getDebugTarget();
                }
                if (debugTarget == null) {
                    return false;
                }
                IPath path = this.convertPath(fileName, debugTarget);
                ITextSelection textSelection = (ITextSelection)selection;
                int lineNumber = textSelection.getStartLine() + 1;
                return moveToLine.canMoveToLine(path.toPortableString(), lineNumber);
            }
            if (part instanceof DisassemblyView) {
                IMoveToAddress moveToAddress = (IMoveToAddress)((IAdaptable)target).getAdapter(IMoveToAddress.class);
                if (moveToAddress == null) {
                    return false;
                }
                IEditorInput input = ((DisassemblyView)part).getInput();
                if (!(input instanceof DisassemblyEditorInput)) {
                    return false;
                }
                ITextSelection textSelection = (ITextSelection)selection;
                int lineNumber = textSelection.getStartLine() + 1;
                IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
                return moveToAddress.canMoveToAddress(address);
            }
        }
        return false;
    }

    private String getFileName(IEditorInput input) throws CoreException {
        return CDebugUIUtils.getEditorFilePath(input);
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, ActionMessages.getString("MoveToLineAdapter.4"), null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), e));
        CDebugUtils.error((IStatus)ms, (Object)this);
    }

    private IPath convertPath(String sourceHandle, IDebugTarget debugTarget) {
        Path path = null;
        if (Path.EMPTY.isValidPath(sourceHandle)) {
            ISourceLocator sl;
            if (debugTarget != null && (sl = debugTarget.getLaunch().getSourceLocator()) instanceof CSourceLookupDirector) {
                path = ((CSourceLookupDirector)sl).getCompilationPath(sourceHandle);
            }
            if (path == null) {
                path = new Path(sourceHandle);
            }
        }
        return path;
    }
}

