/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.util.Map;
import org.eclipse.cdt.core.settings.model.CMacroEntry;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICMacroEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.PathInfo;
import org.eclipse.core.runtime.IPath;

public class PathInfoToLangSettingsConverter {
    public static int getSupportedEntryKinds(IDiscoveredPathManager.IDiscoveredPathInfo info) {
        if (info instanceof IDiscoveredPathManager.IPerFileDiscoveredPathInfo) {
            return PathInfoToLangSettingsConverter.getSupportedEntryKinds((IDiscoveredPathManager.IPerFileDiscoveredPathInfo)info);
        }
        return 5;
    }

    public static int getSupportedEntryKinds(IDiscoveredPathManager.IPerFileDiscoveredPathInfo info) {
        return 15;
    }

    public static ICLanguageSettingEntry[] entriesForKind(int kind, int flags, PathInfo info) {
        switch (kind) {
            case 1: {
                ICLanguageSettingEntry[] incPaths = PathInfoToLangSettingsConverter.calculateEntries(kind, flags, info.getIncludePaths());
                IPath[] quotedPaths = info.getQuoteIncludePaths();
                if (quotedPaths.length != 0) {
                    if (incPaths.length != 0) {
                        ICLanguageSettingEntry[] quotedEntries = PathInfoToLangSettingsConverter.calculateEntries(kind, flags, quotedPaths);
                        ICLanguageSettingEntry[] tmp = new ICLanguageSettingEntry[incPaths.length + quotedEntries.length];
                        System.arraycopy(incPaths, 0, tmp, 0, incPaths.length);
                        System.arraycopy(quotedEntries, 0, tmp, incPaths.length, quotedEntries.length);
                        incPaths = tmp;
                    } else {
                        incPaths = PathInfoToLangSettingsConverter.calculateEntries(kind, flags, quotedPaths);
                    }
                }
                return incPaths;
            }
            case 4: {
                return PathInfoToLangSettingsConverter.calculateEntries(flags, info.getSymbols());
            }
            case 8: {
                return PathInfoToLangSettingsConverter.calculateEntries(kind, flags, info.getMacroFiles());
            }
            case 2: {
                return PathInfoToLangSettingsConverter.calculateEntries(kind, flags, info.getIncludeFiles());
            }
        }
        return new ICLanguageSettingEntry[0];
    }

    private static ICLanguageSettingEntry[] calculateEntries(int kind, int flags, IPath[] values) {
        ICLanguageSettingEntry[] entries = new ICLanguageSettingEntry[values.length];
        int i = 0;
        while (i < values.length) {
            entries[i] = (ICLanguageSettingEntry)CDataUtil.createEntry((int)kind, (String)values[i].toString(), null, null, (int)flags);
            ++i;
        }
        return entries;
    }

    private static ICMacroEntry[] calculateEntries(int flags, Map map) {
        ICMacroEntry[] entries = new ICMacroEntry[map.size()];
        int num = 0;
        for (Map.Entry entry : map.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            entries[num++] = new CMacroEntry(name, value, flags);
        }
        return entries;
    }
}

