/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiscoveredPathInfo
implements IDiscoveredPathManager.IPerProjectDiscoveredPathInfo,
IDiscoveredPathManager.IDiscoveredScannerInfoSerializable {
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    public static final String REMOVED = "removed";
    private final IProject project;
    private LinkedHashMap discoveredPaths;
    private LinkedHashMap discoveredSymbols;
    private List activePaths;
    private Map activeSymbols;

    public DiscoveredPathInfo(IProject project) {
        this.project = project;
        this.discoveredPaths = new LinkedHashMap();
        this.discoveredSymbols = new LinkedHashMap();
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized Map getSymbols() {
        if (this.activeSymbols == null) {
            this.createSymbolsMap();
        }
        Map dSymbols = ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols);
        return dSymbols;
    }

    public synchronized IPath[] getIncludePaths() {
        if (this.activePaths == null) {
            this.createPathLists();
        }
        return this.activePaths.toArray(new IPath[this.activePaths.size()]);
    }

    public LinkedHashMap getIncludeMap() {
        return new LinkedHashMap(this.discoveredPaths);
    }

    public synchronized void setIncludeMap(LinkedHashMap paths) {
        this.discoveredPaths = new LinkedHashMap(paths);
        this.activePaths = null;
    }

    private void createPathLists() {
        List aPaths = this.getActivePathList();
        aPaths.clear();
        for (String path : this.discoveredPaths.keySet()) {
            Boolean removed = (Boolean)this.discoveredPaths.get(path);
            if (removed != null && removed.booleanValue()) continue;
            aPaths.add(new Path(path));
        }
    }

    public LinkedHashMap getSymbolMap() {
        return new LinkedHashMap(this.discoveredSymbols);
    }

    public synchronized void setSymbolMap(LinkedHashMap symbols) {
        this.discoveredSymbols = new LinkedHashMap(symbols);
        this.activeSymbols = null;
    }

    private void createSymbolsMap() {
        Map aSymbols = this.getActiveSymbolsMap();
        aSymbols.clear();
        aSymbols.putAll(ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols));
    }

    private List getActivePathList() {
        if (this.activePaths == null) {
            this.activePaths = new ArrayList();
        }
        return this.activePaths;
    }

    private Map getActiveSymbolsMap() {
        if (this.activeSymbols == null) {
            this.activeSymbols = new HashMap();
        }
        return this.activeSymbols;
    }

    public void serialize(Element collectorElem) {
        Document doc = collectorElem.getOwnerDocument();
        LinkedHashMap includes = this.getIncludeMap();
        Iterator iter = includes.keySet().iterator();
        while (iter.hasNext()) {
            Element pathElement = doc.createElement(INCLUDE_PATH);
            String include = (String)iter.next();
            pathElement.setAttribute(PATH, include);
            Boolean removed = (Boolean)includes.get(include);
            if (removed != null && removed.booleanValue()) {
                pathElement.setAttribute(REMOVED, "true");
            }
            collectorElem.appendChild(pathElement);
        }
        LinkedHashMap symbols = this.getSymbolMap();
        for (String symbol : symbols.keySet()) {
            Element symbolElement;
            SymbolEntry se = (SymbolEntry)symbols.get(symbol);
            for (String value : se.getActiveRaw()) {
                symbolElement = doc.createElement(DEFINED_SYMBOL);
                symbolElement.setAttribute(SYMBOL, value);
                collectorElem.appendChild(symbolElement);
            }
            for (String value : se.getRemovedRaw()) {
                symbolElement = doc.createElement(DEFINED_SYMBOL);
                symbolElement.setAttribute(SYMBOL, value);
                symbolElement.setAttribute(REMOVED, "true");
                collectorElem.appendChild(symbolElement);
            }
        }
    }

    public void deserialize(Element collectorElem) {
        LinkedHashMap includes = this.getIncludeMap();
        LinkedHashMap symbols = this.getSymbolMap();
        Node child = collectorElem.getFirstChild();
        while (child != null) {
            if (child.getNodeName().equals(INCLUDE_PATH)) {
                includes.put(((Element)child).getAttribute(PATH), Boolean.valueOf(((Element)child).getAttribute(REMOVED)));
            } else if (child.getNodeName().equals(DEFINED_SYMBOL)) {
                String symbol = ((Element)child).getAttribute(SYMBOL);
                String removed = ((Element)child).getAttribute(REMOVED);
                boolean bRemoved = removed != null && removed.equals("true");
                ScannerConfigUtil.scAddSymbolString2SymbolEntryMap(symbols, symbol, !bRemoved);
            }
            child = child.getNextSibling();
        }
        this.setIncludeMap(includes);
        this.setSymbolMap(symbols);
    }

    public String getCollectorId() {
        return PerProjectSICollector.COLLECTOR_ID;
    }

    public IDiscoveredPathManager.IDiscoveredScannerInfoSerializable getSerializable() {
        return this;
    }
}

