/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DiscoveredPathContainer
implements IPathEntryContainer {
    public static final IPath CONTAINER_ID = new Path("org.eclipse.cdt.make.core.DISCOVERED_SCANNER_INFO");
    protected final IProject fProject;
    private IPathEntry[] fPathEntries;

    public DiscoveredPathContainer(IProject project) {
        this.fProject = project;
        this.fPathEntries = null;
    }

    public String getDescription() {
        return MakeMessages.getString("DiscoveredContainer.description");
    }

    public IPath getPath() {
        return CONTAINER_ID;
    }

    public IPathEntry[] getPathEntries() {
        if (this.fPathEntries == null) {
            try {
                this.fPathEntries = this.computeNewPathEntries();
            }
            catch (CoreException e) {
                MakeCorePlugin.log(e);
                return new IPathEntry[0];
            }
        }
        return this.fPathEntries;
    }

    private IPathEntry[] computeNewPathEntries() throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo info = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(this.fProject);
        IPath[] includes = info.getIncludePaths();
        Map syms = info.getSymbols();
        ArrayList<Object> entries = new ArrayList<Object>(includes.length + syms.size());
        int i = 0;
        while (i < includes.length) {
            entries.add(CoreModel.newIncludeEntry((IPath)Path.EMPTY, (IPath)Path.EMPTY, (IPath)includes[i], (boolean)true));
            ++i;
        }
        for (Map.Entry entry : syms.entrySet()) {
            entries.add(CoreModel.newMacroEntry((IPath)Path.EMPTY, (String)((String)entry.getKey()), (String)((String)entry.getValue())));
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }
}

