/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.contexts;

import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.contexts.ISuspendTrigger;
import org.eclipse.debug.ui.contexts.ISuspendTriggerListener;

@ConfinedToDsfExecutor(value="fSession.getExecutor()")
public class DsfSuspendTrigger
implements ISuspendTrigger {
    private final DsfSession fSession;
    private final ILaunch fLaunch;
    private boolean fDisposed = false;
    private boolean fEventListenerRegisterd = false;
    @ThreadSafe
    private final ListenerList fListeners = new ListenerList();

    @ThreadSafe
    public DsfSuspendTrigger(DsfSession session, ILaunch launch) {
        this.fSession = session;
        this.fLaunch = launch;
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    if (!DsfSuspendTrigger.this.fDisposed) {
                        DsfSuspendTrigger.this.fSession.addServiceEventListener((Object)DsfSuspendTrigger.this, null);
                        DsfSuspendTrigger.this.fEventListenerRegisterd = true;
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
    }

    @ThreadSafe
    public void addSuspendTriggerListener(ISuspendTriggerListener listener) {
        if (this.fListeners != null) {
            this.fListeners.add((Object)listener);
        }
    }

    @ThreadSafe
    public void removeSuspendTriggerListener(ISuspendTriggerListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    public void dispose() {
        if (this.fEventListenerRegisterd) {
            this.fSession.removeServiceEventListener((Object)this);
        }
        this.fDisposed = true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        final Object[] listeners = this.fListeners.getListeners();
        if (listeners.length != 0) {
            new Job("DSF Suspend Trigger Notify"){
                {
                    super($anonymous0);
                    this.setSystem(true);
                }

                protected IStatus run(IProgressMonitor monitor) {
                    final MultiStatus status = new MultiStatus("org.eclipse.cdt.dsf.ui", 0, "DSF Suspend Trigger Notify Job Status", null);
                    int i = 0;
                    while (i < listeners.length) {
                        final ISuspendTriggerListener listener = (ISuspendTriggerListener)listeners[i];
                        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                            public void run() throws Exception {
                                listener.suspended(DsfSuspendTrigger.this.fLaunch, null);
                            }

                            public void handleException(Throwable exception) {
                                status.add((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", "Exception while calling suspend trigger listeners", exception));
                            }
                        });
                        ++i;
                    }
                    return status;
                }
            }.schedule();
        }
    }
}

