/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.actions;

import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.update.provisional.ICachingVMProviderExtension;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.update.provisional.IVMUpdateScope;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.actions.VMHandlerUtils;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateScopesPropertyTester
extends PropertyTester {
    private static final String SUPPORTED = "areUpdateScopesSupported";
    private static final String AVAILABLE = "isUpdateScopeAvailable";
    private static final String ACTIVE = "isUpdateScopeActive";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IVMProvider provider;
        if (receiver instanceof IVMContext) {
            IVMProvider provider2 = ((IVMContext)receiver).getVMNode().getVMProvider();
            if (provider2 instanceof ICachingVMProviderExtension) {
                return this.testProvider((ICachingVMProviderExtension)provider2, property, expectedValue);
            }
        } else if (receiver instanceof IDebugView && (provider = VMHandlerUtils.getVMProviderForPart((IWorkbenchPart)((IDebugView)receiver))) instanceof ICachingVMProviderExtension) {
            return this.testProvider((ICachingVMProviderExtension)provider, property, expectedValue);
        }
        return false;
    }

    private boolean testProvider(ICachingVMProviderExtension provider, String property, Object expectedValue) {
        if (SUPPORTED.equals(property)) {
            return true;
        }
        if (AVAILABLE.equals(property)) {
            IVMUpdateScope[] iVMUpdateScopeArray = provider.getAvailableUpdateScopes();
            if (iVMUpdateScopeArray.length != 0) {
                IVMUpdateScope scope = iVMUpdateScopeArray[0];
                return scope.getID().equals(expectedValue);
            }
        } else if (ACTIVE.equals(property)) {
            return expectedValue != null && expectedValue.equals(provider.getActiveUpdateScope().getID());
        }
        return false;
    }
}

