/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions;

import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AbstractDisassemblyAction;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;

public final class ActionGotoSymbol
extends AbstractDisassemblyAction {
    public ActionGotoSymbol(IDisassemblyPart disassemblyPart) {
        super(disassemblyPart);
        this.setText(DisassemblyMessages.Disassembly_action_GotoSymbol_label);
    }

    public void run() {
        ISourceViewer viewer = this.getDisassemblyPart().getTextViewer();
        IDocument document = viewer.getDocument();
        IRegion wordRegion = CWordFinder.findWord((IDocument)document, (int)viewer.getSelectedRange().x);
        String defaultValue = null;
        if (wordRegion != null) {
            try {
                defaultValue = document.get(wordRegion.getOffset(), wordRegion.getLength());
            }
            catch (BadLocationException badLocationException) {}
        }
        if (defaultValue == null && (defaultValue = DsfUIPlugin.getDefault().getDialogSettings().get("gotoSymbol")) == null) {
            defaultValue = "";
        }
        String dlgTitle = DisassemblyMessages.Disassembly_GotoSymbolDialog_title;
        String dlgLabel = DisassemblyMessages.Disassembly_GotoSymbolDialog_label;
        Shell shell = this.getDisassemblyPart().getSite().getShell();
        InputDialog dlg = new InputDialog(shell, dlgTitle, dlgLabel, defaultValue, null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            DsfUIPlugin.getDefault().getDialogSettings().put("gotoSymbol", value);
            this.getDisassemblyPart().gotoSymbol(value);
        }
    }
}

