/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.tests.BasicTestCase;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.tcmodification.IConfigurationModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IFolderInfoModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IModificationOperation;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolModification;
import org.eclipse.cdt.managedbuilder.testplugin.BuildSystemTestHelper;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ToolChainModificationTests
extends BasicTestCase {
    private static final String PROJ_NAME_PREFIX = "TCM_";

    public static Test suite() {
        TestSuite suite = new TestSuite(ToolChainModificationTests.class);
        return suite;
    }

    public void testRootToolChainStatus() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p1");
        BuildSystemTestHelper.createDescription(project, "tcm.pt");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        IToolChain[] ctcs = cfgM.getCompatibleToolChains();
        HashSet set = new HashSet();
        FolderInfo foInfo = (FolderInfo)cfg.getRootFolderInfo();
        ToolChain tc = (ToolChain)foInfo.getToolChain();
        IToolChain[] allSys = ManagedBuildManager.getRealToolChains();
        this.filterPropsSupported(foInfo, tc, allSys, set);
        set.remove(ManagedBuildManager.getRealToolChain((IToolChain)tc));
        IToolChain incompatibleTc = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc2");
        incompatibleTc = ManagedBuildManager.getRealToolChain((IToolChain)incompatibleTc);
        set.remove(incompatibleTc);
        this.compare(Arrays.asList(ctcs), set);
        HashSet<IToolChain> incomp = new HashSet<IToolChain>(Arrays.asList(allSys));
        incomp.removeAll(Arrays.asList(ctcs));
        ToolChainModificationTests.assertTrue((boolean)incomp.contains(incompatibleTc));
        IBuilder[] cbs = cfgM.getCompatibleBuilders();
        HashSet bSet = new HashSet();
        IBuilder[] allSysB = ManagedBuildManager.getRealBuilders();
        this.filterPropsSupported(cfg, allSysB, bSet);
        IBuilder incompatibleB = ManagedBuildManager.getExtensionBuilder((String)"tcm.tc4.b1");
        incompatibleB = ManagedBuildManager.getRealBuilder((IBuilder)incompatibleB);
        bSet.remove(cfgM.getRealBuilder());
        bSet.remove(incompatibleB);
        this.compare(Arrays.asList(cbs), bSet);
        HashSet<IBuilder> incompB = new HashSet<IBuilder>(Arrays.asList(allSysB));
        incompB.removeAll(Arrays.asList(cbs));
        ToolChainModificationTests.assertTrue((boolean)incompB.contains(incompatibleB));
        IToolChain tc3 = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc3");
        cfgM.setToolChain(tc3);
        ToolChainModificationTests.assertEquals((Object)tc3, (Object)cfgM.getToolChain());
        ToolChainModificationTests.assertEquals((Object)tc3.getBuilder(), (Object)cfgM.getBuilder());
        IBuilder b5 = ManagedBuildManager.getExtensionBuilder((String)"tcm.tc5.b1");
        cfgM.setBuilder(b5);
        ToolChainModificationTests.assertEquals((Object)tc3, (Object)cfgM.getToolChain());
        ToolChainModificationTests.assertEquals((Object)b5, (Object)cfgM.getBuilder());
        project.delete(true, null);
    }

    private boolean contains(Object[] array, Object obj) {
        return new HashSet<Object>(Arrays.asList(array)).contains(obj);
    }

    private HashSet filterSupportedToolChains(IFolderInfo foInfo, IToolChain tc) {
        HashSet set = new HashSet();
        IToolChain[] allSys = ManagedBuildManager.getRealToolChains();
        this.filterPropsSupported((FolderInfo)foInfo, (ToolChain)tc, allSys, set);
        set.remove(ManagedBuildManager.getRealToolChain((IToolChain)tc));
        return set;
    }

    public void testChildToolChainStatus() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p2");
        BuildSystemTestHelper.createDescription(project, "tcm.pt2");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        Path foPath = new Path("a");
        IFolder fo = project.getFolder((IPath)foPath);
        fo.create(true, true, null);
        IFolderInfo foInfo = cfg.createFolderInfo((IPath)foPath);
        IFolderInfoModification foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertEquals((Object)foM.getToolChain(), (Object)foInfo.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)foM.isToolChainCompatible());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        HashSet set = this.filterSupportedToolChains(cfg.getRootFolderInfo(), cfg.getToolChain());
        IToolChain[] tcs = cfgM.getCompatibleToolChains();
        this.compare(Arrays.asList(tcs), set);
        tcs = foM.getCompatibleToolChains();
        set = this.filterSupportedToolChains(foInfo, foInfo.getToolChain());
        IToolChain incompatibleTc = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc3");
        incompatibleTc = ManagedBuildManager.getRealToolChain((IToolChain)incompatibleTc);
        set.remove(incompatibleTc);
        this.compare(Arrays.asList(tcs), set);
        foM.setToolChain(incompatibleTc);
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        foInfo.changeToolChain(incompatibleTc, CDataUtil.genId((String)"blah.blah"), incompatibleTc.getName());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        project.delete(true, null);
    }

    public void testChildToolChainStatus2() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p3");
        BuildSystemTestHelper.createDescription(project, "tcm.pt.derive1");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        Path foPath = new Path("a");
        IFolder fo = project.getFolder((IPath)foPath);
        fo.create(true, true, null);
        IFolderInfo foInfo = cfg.createFolderInfo((IPath)foPath);
        IFolderInfoModification foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertEquals((Object)foM.getToolChain(), (Object)foInfo.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)foM.isToolChainCompatible());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        HashSet set = this.filterSupportedToolChains(cfg.getRootFolderInfo(), cfg.getToolChain());
        IToolChain[] tcs = cfgM.getCompatibleToolChains();
        this.compare(Arrays.asList(tcs), set);
        tcs = foM.getCompatibleToolChains();
        set = this.filterSupportedToolChains(foInfo, foInfo.getToolChain());
        this.rmToolChains(set, new String[]{"tcm.base2.tc", "tcm.derive2.tc1", "tcm.derive2.tc2", "tcm2.tc2", "tcm2.tc", "tcm2.tc.derive"});
        this.compare(Arrays.asList(tcs), set);
        foM.setToolChain(ManagedBuildManager.getExtensionToolChain((String)"tcm.derive2.tc1"));
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        foInfo.changeToolChain(ManagedBuildManager.getExtensionToolChain((String)"tcm.derive2.tc1"), CDataUtil.genId((String)"blah.blah"), null);
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertFalse((boolean)foM.isToolChainCompatible());
        project.delete(true, null);
    }

    private void rmToolChains(Set set, String[] ids) {
        int i = 0;
        while (i < ids.length) {
            IToolChain incompatibleTc = ManagedBuildManager.getExtensionToolChain((String)ids[i]);
            ToolChainModificationTests.assertNotNull((String)("no tool-chain of id " + ids[i]), (Object)incompatibleTc);
            incompatibleTc = ManagedBuildManager.getRealToolChain((IToolChain)incompatibleTc);
            ToolChainModificationTests.assertTrue((String)("set does not contain tc \"" + incompatibleTc.getId() + "\" which is a real tc for \"" + ids[i] + "\""), (boolean)set.remove(incompatibleTc));
            ++i;
        }
    }

    private IToolChain getRealToolChain(String id) {
        IToolChain tc = ManagedBuildManager.getExtensionToolChain((String)id);
        return ManagedBuildManager.getRealToolChain((IToolChain)tc);
    }

    private void compare(Collection c1, Collection c2) {
        HashSet s1 = new HashSet(c1);
        HashSet s1c = (HashSet)s1.clone();
        HashSet s2 = new HashSet(c2);
        s1.removeAll(s2);
        s2.removeAll(s1c);
        StringBuffer buf = new StringBuffer();
        buf.append("checking c1..\n");
        boolean fail = this.checkEmpty(s1, buf);
        buf.append("checking c2..\n");
        if (fail |= this.checkEmpty(s2, buf)) {
            ToolChainModificationTests.fail((String)buf.toString());
        }
    }

    private boolean checkEmpty(Collection c, StringBuffer buf) {
        if (c.size() != 0) {
            buf.append("non-empty dump:\n");
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                buf.append("\t ").append(((IBuildObject)iter.next()).getId()).append('\n');
            }
            buf.append("end\n");
            return true;
        }
        return false;
    }

    private Collection filterPropsSupported(FolderInfo foInfo, ToolChain tc, IToolChain[] tcs, Collection c) {
        if (c == null) {
            c = new ArrayList<IToolChain>();
        }
        int i = 0;
        while (i < tcs.length) {
            if (foInfo.isToolChainCompatible(tc, tcs[i])) {
                c.add(tcs[i]);
            }
            ++i;
        }
        return c;
    }

    private Collection filterPropsSupported(IConfiguration cfg, IBuilder[] bs, Collection c) {
        if (c == null) {
            c = new ArrayList<IBuilder>();
        }
        int i = 0;
        while (i < bs.length) {
            if (cfg.isBuilderCompatible(bs[i])) {
                c.add(bs[i]);
            }
            ++i;
        }
        return c;
    }

    private boolean getReplacementToolInfo(IModificationOperation[] ops, Set set) {
        boolean removable = false;
        int i = 0;
        while (i < ops.length) {
            ITool tool = ops[i].getReplacementTool();
            if (tool == null) {
                removable = true;
            } else {
                set.add(tool);
            }
            ++i;
        }
        return removable;
    }

    public void testToolModificationWithChild() throws Exception {
        IProject project = BuildSystemTestHelper.createProject("TCM_p4");
        BuildSystemTestHelper.createDescription(project, "tcm.pt");
        ICProjectDescriptionManager desMngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = desMngr.getProjectDescription(project);
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)des.getConfigurations()[0]);
        IToolChain tc4 = ManagedBuildManager.getExtensionToolChain((String)"tcm.tc4");
        cfg.getRootFolderInfo().changeToolChain(tc4, CDataUtil.genId(null), null);
        IToolChainModificationManager mngr = ManagedBuildManager.getToolChainModificationManager();
        IConfigurationModification cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        Path foPath = new Path("a");
        IFolder fo = project.getFolder((IPath)foPath);
        fo.create(true, true, null);
        IFolderInfo foInfo = cfg.createFolderInfo((IPath)foPath);
        IFolderInfoModification foM = mngr.createModification(foInfo);
        ToolChainModificationTests.assertEquals((Object)foM.getToolChain(), (Object)foInfo.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)foM.isToolChainCompatible());
        cfgM = (IConfigurationModification)mngr.createModification(cfg.getRootFolderInfo());
        ToolChainModificationTests.assertEquals((Object)cfgM.getToolChain(), (Object)cfg.getToolChain());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isToolChainCompatible());
        ToolChainModificationTests.assertTrue((boolean)cfgM.isBuilderCompatible());
        ITool tool41 = ManagedBuildManager.getExtensionTool((String)"tcm.tc4.t1");
        IToolModification tm = cfgM.getToolModification(tool41);
        ToolChainModificationTests.assertTrue((boolean)tm.isProjectTool());
        IModificationOperation[] ops = tm.getSupportedOperations();
        ITool tool31 = ManagedBuildManager.getExtensionTool((String)"tcm.tc3.t1");
        HashSet replacement = new HashSet();
        boolean removable = this.getReplacementToolInfo(ops, replacement);
        ToolChainModificationTests.assertFalse((boolean)removable);
        ToolChainModificationTests.assertTrue((boolean)replacement.contains(tool31));
        tm = foM.getToolModification(tool41);
        ToolChainModificationTests.assertTrue((boolean)tm.isProjectTool());
        ops = tm.getSupportedOperations();
        replacement = new HashSet();
        removable = this.getReplacementToolInfo(ops, replacement);
        ToolChainModificationTests.assertFalse((boolean)removable);
        ToolChainModificationTests.assertFalse((boolean)replacement.contains(tool31));
        project.delete(true, null);
    }
}

