/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.mingw;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class MingwEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private IBuildEnvironmentVariable path;

    public static IPath getBinDir() {
        Path subPath = new Path("mingw\\bin");
        Path installPath = new Path(Platform.getInstallLocation().getURL().getFile());
        IPath binPath = installPath.append((IPath)subPath);
        if (binPath.toFile().isDirectory()) {
            return binPath;
        }
        binPath = installPath.removeLastSegments(1).append((IPath)subPath);
        if (binPath.toFile().isDirectory()) {
            return binPath;
        }
        WindowsRegistry registry = WindowsRegistry.getRegistry();
        if (registry == null) {
            return null;
        }
        String mingwPath = registry.getLocalMachineValue("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MinGW", "InstallLocation");
        if (mingwPath != null && (binPath = new Path(mingwPath).append("bin")).toFile().isDirectory()) {
            return binPath;
        }
        binPath = new Path("C:\\MinGW\\bin");
        if (binPath.toFile().isDirectory()) {
            return binPath;
        }
        return null;
    }

    public static IPath getMsysBinDir() {
        IPath installPath = new Path(Platform.getInstallLocation().getURL().getFile()).removeLastSegments(1);
        IPath msysBinPath = installPath.append("msys\\bin");
        return msysBinPath.toFile().isDirectory() ? msysBinPath : null;
    }

    public MingwEnvironmentVariableSupplier() {
        IPath binPath = MingwEnvironmentVariableSupplier.getBinDir();
        if (binPath != null) {
            String pathStr = binPath.toOSString();
            IPath msysBinPath = MingwEnvironmentVariableSupplier.getMsysBinDir();
            if (msysBinPath != null) {
                pathStr = String.valueOf(pathStr) + ';' + msysBinPath.toOSString();
            }
            this.path = new MingwBuildEnvironmentVariable("PATH", pathStr, 3);
        }
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (this.path != null && variableName.equals(this.path.getName())) {
            return this.path;
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray;
        if (this.path != null) {
            IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = new IBuildEnvironmentVariable[1];
            iBuildEnvironmentVariableArray = iBuildEnvironmentVariableArray2;
            iBuildEnvironmentVariableArray2[0] = this.path;
        } else {
            iBuildEnvironmentVariableArray = new IBuildEnvironmentVariable[]{};
        }
        return iBuildEnvironmentVariableArray;
    }

    private static class MingwBuildEnvironmentVariable
    implements IBuildEnvironmentVariable {
        private final String name;
        private final String value;
        private final int operation;

        public MingwBuildEnvironmentVariable(String name, String value, int operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getDelimiter() {
            return ";";
        }
    }
}

